/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import nl.rslot.ssx.HotbarItemManager;
import nl.rslot.ssx.Main;
import nl.rslot.ssx.actions.Action;
import nl.rslot.ssx.lib.checkerframework.checker.nullness.qual.Nullable;
import nl.rslot.ssx.lib.derkutils.Cooldown;
import nl.rslot.ssx.placeholders.Server;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ServerSelectorX {
    public static void registerAction(Action action) {
        Action.ACTIONS.add(action);
    }

    public static boolean runAction(Player player, String actionString) {
        return Action.runAction(player, actionString);
    }

    public static boolean runActions(Player player, List<String> actionStrings) {
        return Action.runActions(player, actionStrings);
    }

    public static @Nullable Server getServer(String name) {
        return Main.placeholderReceiver().getServer(name);
    }

    public static Collection<Server> getServers() {
        return Collections.unmodifiableCollection(Main.placeholderReceiver().getServers().values());
    }

    public static int getGlobalPlayerCount() {
        return ServerSelectorX.getServers().stream().mapToInt(Server::getOnlinePlayers).sum();
    }

    public static void teleportPlayerToServer(Player player, String server) {
        if (Cooldown.getCooldown("servertp" + player.getName() + server) > 0L) {
            return;
        }
        Cooldown.addCooldown("servertp" + player.getName() + server, 1000L);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             DataOutputStream dos = new DataOutputStream(baos);){
            dos.writeUTF("Connect");
            dos.writeUTF(server);
            player.sendPluginMessage((Plugin)Main.getPlugin(), "BungeeCord", baos.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static HotbarItemManager getHotbarItemManager() {
        return Main.getPlugin().getHotbarItemManager();
    }
}

