/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx;

import java.util.List;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import nl.rslot.ssx.Commands;
import nl.rslot.ssx.Main;
import nl.rslot.ssx.Menu;
import nl.rslot.ssx.ServerSelectorX;
import nl.rslot.ssx.lib.jetbrains-annotations.NotNull;
import nl.rslot.ssx.placeholders.GlobalPlaceholder;
import nl.rslot.ssx.placeholders.Placeholder;
import nl.rslot.ssx.placeholders.PlayerPlaceholder;
import nl.rslot.ssx.placeholders.Server;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class ServerSelectorXCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        if (!sender.hasPermission("ssx.admin")) {
            sender.sendMessage(ChatColor.RED + "You need the permission 'ssx.admin' to execute this command.");
            return true;
        }
        if (args.length == 3 && args[0].equals("openmenu")) {
            String menuName = args[1];
            String playerName = args[2];
            Player player = Bukkit.getPlayerExact((String)playerName);
            if (player == null) {
                sender.sendMessage("No online player found with name '" + playerName + "'.");
                return true;
            }
            FileConfiguration config = Main.getConfigurationManager().getMenuConfiguration(menuName);
            if (config == null) {
                sender.sendMessage("No menu exists with name '" + menuName + "'.");
                sender.sendMessage("The menu name is the name of the menu file, without its extension.");
                sender.sendMessage("For example, for a menu file called 'serverselector.yml', enter 'serverselector'.");
                return true;
            }
            new Menu(player, config, menuName);
            return true;
        }
        if (args.length == 2) {
            switch (args[0]) {
                case "placeholders": {
                    String serverName = args[1];
                    Server server = Main.placeholderReceiver().getServer(serverName);
                    if (server == null) {
                        sender.sendMessage("The server '" + serverName + "' does not exist or is currently offline");
                        return true;
                    }
                    sender.sendMessage("Placeholders for " + serverName);
                    for (Placeholder placeholder : server.getPlaceholders()) {
                        if (placeholder instanceof PlayerPlaceholder) {
                            sender.sendMessage(placeholder.getKey());
                            PlayerPlaceholder pp = (PlayerPlaceholder)placeholder;
                            pp.getValues().forEach((uuid, value) -> sender.sendMessage("  " + uuid + ": " + value));
                            continue;
                        }
                        sender.sendMessage(placeholder.getKey() + ": " + ((GlobalPlaceholder)placeholder).getValue());
                    }
                    return true;
                }
                case "updateitems": {
                    Player player = Bukkit.getPlayerExact((String)args[1]);
                    if (player == null) {
                        sender.sendMessage("No player found with the provided name");
                        return true;
                    }
                    Main.getPlugin().getHotbarItemManager().updateSsxItems(player);
                    sender.sendMessage("Updated hotbar items for: " + player.getName());
                    return true;
                }
            }
        } else if (args.length == 1) {
            switch (args[0]) {
                case "rl": 
                case "reload": {
                    try {
                        Main.getConfigurationManager().reload();
                        sender.sendMessage("The configuration file has been reloaded.");
                    }
                    catch (Exception e) {
                        sender.sendMessage(ChatColor.RED + "An error occured while trying to reload the configuration files, probably because of a YAML syntax error.");
                        sender.sendMessage("Error: " + e.getMessage());
                        sender.sendMessage("For a more detailed error message see the console.");
                        e.printStackTrace();
                        return true;
                    }
                    Main.placeholderReceiver().loadConfiguration();
                    Main.getPlugin().getHotbarItemManager().updateSsxItems();
                    sender.sendMessage("Run " + ChatColor.GRAY + "/ssx reloadcommands" + ChatColor.RESET + " to reload commands.");
                    return true;
                }
                case "reloadcommands": 
                case "rlcmd": {
                    Commands.registerCustomCommands();
                    sender.sendMessage("Re-registered custom commands.");
                    sender.sendMessage("Commands are not unregistered, if you disabled or renamed a command the old command will still work until the server is restarted.");
                    return true;
                }
                case "status": {
                    sender.sendMessage(Main.placeholderReceiver().getStatus());
                    sender.sendMessage("Servers:");
                    for (Server server : ServerSelectorX.getServers()) {
                        List placeholderKeys = server.getPlaceholders().stream().map(Placeholder::getKey).collect(Collectors.toList());
                        sender.sendMessage(server.getName() + ": " + ChatColor.GRAY + String.join((CharSequence)", ", placeholderKeys));
                    }
                    return true;
                }
                case "items": {
                    Main.getConfigurationManager().listItemConfigurations().forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
                    return true;
                }
                case "menus": {
                    Main.getConfigurationManager().listMenuConfigurations().forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
                    return true;
                }
                case "commands": {
                    Main.getConfigurationManager().listCommandConfigurations().forEach(arg_0 -> ((CommandSender)sender).sendMessage(arg_0));
                    return true;
                }
                case "itemdebug": {
                    Main.ITEM_DEBUG = true;
                    sender.sendMessage("Debug messages related to item giving and clicking are now enabled until the next server restart/reload.");
                    return true;
                }
                case "updateitems": {
                    Main.getPlugin().getHotbarItemManager().updateSsxItems();
                    sender.sendMessage("Updated hotbar items for all online players");
                    return true;
                }
            }
        }
        return false;
    }
}

