/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nl.rslot.ssx.Main;
import nl.rslot.ssx.actions.AddEffectAction;
import nl.rslot.ssx.actions.AdvMessageAction;
import nl.rslot.ssx.actions.ChatAction;
import nl.rslot.ssx.actions.CloseAction;
import nl.rslot.ssx.actions.ConsoleCommandAction;
import nl.rslot.ssx.actions.DelayAction;
import nl.rslot.ssx.actions.FirstAvailableServerAction;
import nl.rslot.ssx.actions.MessageAction;
import nl.rslot.ssx.actions.OpenMenuAction;
import nl.rslot.ssx.actions.PlayerCommandAction;
import nl.rslot.ssx.actions.RandomServerAction;
import nl.rslot.ssx.actions.RoundRobinServerAction;
import nl.rslot.ssx.actions.ServerAction;
import nl.rslot.ssx.actions.ServerGroupAction;
import nl.rslot.ssx.actions.SoundAction;
import nl.rslot.ssx.actions.TeleportAction;
import nl.rslot.ssx.actions.ToggleEffectAction;
import nl.rslot.ssx.actions.ToggleHideOthersAction;
import nl.rslot.ssx.actions.UrlAction;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public abstract class Action {
    private static final Action[] DEFAULT_ACTIONS = new Action[]{new AddEffectAction(), new AdvMessageAction(), new ChatAction(), new CloseAction(), new ConsoleCommandAction(), new DelayAction(), new FirstAvailableServerAction(), new MessageAction(), new OpenMenuAction(), new PlayerCommandAction(), new RandomServerAction(), new RoundRobinServerAction(), new ServerAction(), new ServerGroupAction(), new SoundAction(), new TeleportAction(), new ToggleEffectAction(), new ToggleHideOthersAction(), new UrlAction()};
    public static final List<Action> ACTIONS = new ArrayList<Action>();
    private final String name;
    private final boolean requiresValue;

    public Action(String name, boolean requiresValue) {
        this.name = name;
        this.requiresValue = requiresValue;
    }

    public String getName() {
        return this.name;
    }

    public boolean requiresValue() {
        return this.requiresValue;
    }

    public abstract boolean apply(Player var1, String var2);

    public static boolean runAction(Player player, String actionString) {
        String actionName;
        boolean hasValue;
        if (actionString.contains(":")) {
            hasValue = true;
            actionName = actionString.split(":")[0];
        } else {
            hasValue = false;
            actionName = actionString;
        }
        for (Action action : ACTIONS) {
            if (!action.getName().equals(actionName)) continue;
            if (action.requiresValue()) {
                if (hasValue) {
                    String value = actionString.substring(actionName.length() + 1);
                    return action.apply(player, value);
                }
                player.sendMessage("Action '" + actionName + "' requires a value");
                return true;
            }
            if (!hasValue) {
                return action.apply(player, null);
            }
            player.sendMessage("Action '" + actionName + "' does not require a value");
            return true;
        }
        player.sendMessage("Invalid action: '" + actionName + "'");
        return true;
    }

    public static boolean runActions(Player player, List<String> actionStrings) {
        if (actionStrings.isEmpty()) {
            return false;
        }
        boolean close = false;
        for (String actionString : actionStrings) {
            if (!Action.runAction(player, actionString)) continue;
            close = true;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)Main.getPlugin(), () -> Main.getPlugin().getHotbarItemManager().updateSsxItems(player), 0L);
        return close;
    }

    static {
        ACTIONS.addAll(Arrays.asList(DEFAULT_ACTIONS));
    }
}

