/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.actions;

import java.util.HashMap;
import java.util.Map;
import nl.rslot.ssx.ServerSelectorX;
import nl.rslot.ssx.actions.Action;
import nl.rslot.ssx.placeholders.Server;
import org.bukkit.entity.Player;

public class RoundRobinServerAction
extends Action {
    private static final int MAX_ATTEMPTS = 20;
    private static final Map<String, Integer> LAST_USED_SERVER = new HashMap<String, Integer>();
    private static final Map<String, Integer> ATTEMPTS = new HashMap<String, Integer>();

    public RoundRobinServerAction() {
        super("roundrobinserver", true);
    }

    @Override
    public boolean apply(Player player, String value) {
        String[] serverNames = value.split(":");
        if (!LAST_USED_SERVER.containsKey(value)) {
            this.teleportIfPossible(player, serverNames[0], value);
            LAST_USED_SERVER.put(value, 0);
        } else {
            int index = LAST_USED_SERVER.get(value) + 1;
            if (serverNames.length >= index) {
                index = 0;
            }
            this.teleportIfPossible(player, serverNames[index], value);
            LAST_USED_SERVER.put(value, index);
        }
        return false;
    }

    private void teleportIfPossible(Player player, String serverName, String value) {
        if (ATTEMPTS.containsKey(value)) {
            int attempts = ATTEMPTS.get(value);
            if (attempts >= 20) {
                return;
            }
            ATTEMPTS.put(value, attempts + 1);
        } else {
            ATTEMPTS.put(value, 1);
        }
        Server server = ServerSelectorX.getServer(serverName);
        if (server == null) {
            this.apply(player, value);
        }
        if (server.getOnlinePlayers() >= server.getMaximumPlayers()) {
            this.apply(player, value);
        }
        ServerSelectorX.teleportPlayerToServer(player, serverName);
    }
}

