/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.conditional;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import nl.rslot.ssx.Main;
import nl.rslot.ssx.ServerSelectorX;
import nl.rslot.ssx.actions.Action;
import nl.rslot.ssx.conditional.condition.Condition;
import nl.rslot.ssx.conditional.condition.Conditions;
import nl.rslot.ssx.lib.derkutils.Cooldown;
import nl.rslot.ssx.lib.derkutils.bukkit.Colors;
import nl.rslot.ssx.lib.derkutils.bukkit.PlaceholderUtil;
import nl.rslot.ssx.lib.derkutils.bukkit.menu.OptionClickEvent;
import nl.rslot.ssx.lib.jetbrains-annotations.NotNull;
import nl.rslot.ssx.lib.jetbrains-annotations.Nullable;
import nl.rslot.ssx.lib.nbtapi.NBT;
import nl.rslot.ssx.lib.nbtapi.NbtApiException;
import nl.rslot.ssx.lib.nbtapi.iface.ReadWriteNBT;
import nl.rslot.ssx.lib.nbtapi.iface.ReadableNBT;
import nl.rslot.ssx.lib.nbtapi.iface.ReadableNBTList;
import nl.rslot.ssx.placeholders.Server;
import org.bukkit.Color;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class ConditionalItem {
    private static Map<String, Object> matchSection(Player player, ConfigurationSection globalSection) throws InvalidConfigurationException {
        if (!globalSection.contains("conditional")) {
            return ConditionalItem.sectionToMap(globalSection);
        }
        List conditionalsList = globalSection.getMapList("conditional");
        Iterator iterator = conditionalsList.iterator();
        while (iterator.hasNext()) {
            Map genericMap;
            Map map = genericMap = (Map)iterator.next();
            for (String key : globalSection.getKeys(false)) {
                map.putIfAbsent(key, globalSection.get(key));
            }
            if (!map.containsKey("type")) {
                throw new InvalidConfigurationException("Missing 'type' option for a conditional");
            }
            String type = (String)map.get("type");
            boolean invert = map.getOrDefault("invert-condition", false);
            Condition condition = Conditions.getConditionByType(type);
            if (condition == null) {
                throw new InvalidConfigurationException("Unknown condition type: " + type);
            }
            if (condition.isTrue(player, map) == invert) continue;
            return map;
        }
        return ConditionalItem.sectionToMap(globalSection);
    }

    private static Map<String, Object> sectionToMap(ConfigurationSection section) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : section.getKeys(false)) {
            map.put(key, section.get(key));
        }
        return map;
    }

    public static void getItem(@NotNull Player player, @NotNull ConfigurationSection section, @NotNull String cooldownId, @NotNull @NotNull Consumer<@NotNull ItemStack> consumer) throws InvalidConfigurationException {
        Map<String, Object> matchedSection = ConditionalItem.matchSection(player, section);
        String materialString = matchedSection.getOrDefault("material", null);
        if (materialString == null) {
            throw new InvalidConfigurationException("Material is missing from config or null");
        }
        Main.getItemBuilderFromMaterialString(player, materialString, builder -> {
            Server server;
            boolean useMiniMessage = matchedSection.getOrDefault("minimessage", false);
            String title = matchedSection.getOrDefault("title", " ");
            List lore = matchedSection.getOrDefault("lore", Collections.emptyList());
            boolean enchanted = matchedSection.getOrDefault("enchanted", false);
            boolean hideFlags = matchedSection.getOrDefault("hide-flags", true);
            boolean amountOnline = matchedSection.getOrDefault("amount-online", false);
            int amount = matchedSection.getOrDefault("amount", 1);
            int durability = matchedSection.getOrDefault("durability", -1);
            int data = matchedSection.getOrDefault("data", -1);
            @Nullable String nbtJson = matchedSection.getOrDefault("nbt", null);
            List actions = matchedSection.getOrDefault("actions", Collections.emptyList());
            List leftClickActions = matchedSection.getOrDefault("left-click-actions", Collections.emptyList());
            List rightClickActions = matchedSection.getOrDefault("right-click-actions", Collections.emptyList());
            int cooldownTime = matchedSection.getOrDefault("cooldown", 0);
            List cooldownActions = matchedSection.getOrDefault("cooldown-actions", Collections.emptyList());
            @Nullable String serverName = (String)matchedSection.get("server-name");
            @Nullable String color = (String)matchedSection.get("color");
            Server server2 = server = serverName != null ? Main.placeholderReceiver().getServer(serverName) : null;
            if (server != null && amountOnline) {
                int online = server.getOnlinePlayers();
                amount = online >= 1 && online <= 64 ? online : 1;
            }
            Function<String, String> stringConverter = string -> {
                string = PlaceholderUtil.parsePapiPlaceholders(player, string);
                if (server != null) {
                    string = server.parsePlaceholders(player, (String)string);
                }
                string = string.replace("{player}", player.getName());
                string = string.replace("{globalOnline", String.valueOf(ServerSelectorX.getGlobalPlayerCount()));
                string = useMiniMessage ? Main.miniMessageToLegacy(string) : "&r&f" + string;
                string = Colors.parseColors(string);
                return string;
            };
            builder.name(stringConverter.apply(title));
            if (!lore.isEmpty()) {
                ArrayList<String> parsedLore = new ArrayList<String>(lore.size());
                for (String line : lore) {
                    parsedLore.add(stringConverter.apply(line));
                }
                builder.lore(parsedLore);
            }
            if (enchanted) {
                builder.unsafeEnchant(Enchantment.DURABILITY, 1);
            }
            builder.hideFlags(hideFlags);
            builder.amount(amount);
            if (durability >= 0) {
                builder.damage(durability);
            }
            if (data >= 0) {
                builder.damage(data);
            }
            if (color != null) {
                if (color.length() != 7 || color.charAt(0) != '#') {
                    player.sendMessage("Invalid color '" + color + "', should be a # followed by 6 hex digits");
                    return;
                }
                int r = Integer.parseInt(color.substring(1, 3), 16);
                int g = Integer.parseInt(color.substring(3, 5), 16);
                int b = Integer.parseInt(color.substring(5, 7), 16);
                builder.leatherArmorColor(Color.fromRGB((int)r, (int)g, (int)b));
            }
            if (nbtJson != null) {
                try {
                    ReadWriteNBT nbtToAdd = NBT.parseNBT(nbtJson);
                    builder.editNbt(nbt -> nbt.mergeCompound(nbtToAdd));
                }
                catch (NbtApiException e) {
                    player.sendMessage("Skipped adding custom NBT to an item because of an error, please see the console for more info.");
                    e.printStackTrace();
                }
            }
            builder.editNbt(nbt -> {
                nbt.getStringList("SSXActions").addAll(actions);
                nbt.getStringList("SSXActionsLeft").addAll(leftClickActions);
                nbt.getStringList("SSXActionsRight").addAll(rightClickActions);
                if (cooldownTime > 0) {
                    nbt.setInteger("SSXCooldownTime", cooldownTime);
                    nbt.setString("SSXCooldownId", cooldownId);
                    nbt.getStringList("SSXCooldownActions").addAll(cooldownActions);
                }
            });
            consumer.accept(builder.create());
        });
    }

    public static boolean runActions(OptionClickEvent event) {
        ClickType click = event.getClickType();
        boolean leftClick = click == ClickType.LEFT || click == ClickType.SHIFT_LEFT;
        boolean rightClick = click == ClickType.RIGHT || click == ClickType.SHIFT_RIGHT;
        return ConditionalItem.runActions(event.getPlayer(), event.getItemStack(), leftClick, rightClick);
    }

    public static boolean runActions(PlayerInteractEvent event) {
        boolean leftClick = event.getAction() == org.bukkit.event.block.Action.LEFT_CLICK_AIR || event.getAction() == org.bukkit.event.block.Action.LEFT_CLICK_BLOCK;
        boolean rightClick = event.getAction() == org.bukkit.event.block.Action.RIGHT_CLICK_AIR || event.getAction() == org.bukkit.event.block.Action.RIGHT_CLICK_BLOCK;
        return ConditionalItem.runActions(event.getPlayer(), event.getItem(), leftClick, rightClick);
    }

    private static boolean runActions(Player player, ItemStack item, boolean isLeftClick, boolean isRightClick) {
        if (item == null) {
            Main.getPlugin().getLogger().warning("Received click event for null item. This is a bug.");
            return false;
        }
        ReadableNBT nbt = NBT.readNbt(item);
        ReadableNBTList<String> actions = nbt.getStringList("SSXActions");
        ReadableNBTList<String> leftActions = nbt.getStringList("SSXActionsLeft");
        ReadableNBTList<String> rightActions = nbt.getStringList("SSXActionsRight");
        if (nbt.hasTag("SSXCooldownTime") && (!actions.isEmpty() || isRightClick && !rightActions.isEmpty() || isLeftClick && !leftActions.isEmpty())) {
            int cooldownTime = nbt.getInteger("SSXCooldownTime");
            String cooldownId = nbt.getString("SSXCooldownId");
            if (Cooldown.getCooldown(cooldownId) > 0L) {
                ReadableNBTList<String> cooldownActions = nbt.getStringList("SSXCooldownActions");
                return Action.runActions(player, cooldownActions.toListCopy());
            }
            Cooldown.addCooldown(cooldownId, cooldownTime);
        }
        boolean close = false;
        if (actions != null) {
            close = Action.runActions(player, actions.toListCopy());
        }
        if (isRightClick && rightActions != null) {
            close |= Action.runActions(player, rightActions.toListCopy());
        } else if (isLeftClick && leftActions != null) {
            close |= Action.runActions(player, leftActions.toListCopy());
        }
        return close;
    }
}

