/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.conditional.condition;

import java.util.List;
import java.util.Map;
import nl.rslot.ssx.conditional.condition.Condition;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Player;

public class InWorldCondition
extends Condition {
    InWorldCondition() {
        super("in-world");
    }

    @Override
    public boolean isTrue(Player player, Map<String, Object> options) throws InvalidConfigurationException {
        if (options.containsKey("world")) {
            if (options.containsKey("worlds")) {
                throw new InvalidConfigurationException("Cannot use 'world' and 'worlds' option at the same time");
            }
            String worldName = (String)options.get("world");
            return player.getWorld().getName().equals(worldName);
        }
        if (options.containsKey("worlds")) {
            List worldNames = (List)options.get("worlds");
            for (String worldName : worldNames) {
                if (!player.getWorld().getName().equals(worldName)) continue;
                return true;
            }
            return false;
        }
        if (options.containsKey("world-regex")) {
            String worldRegex = (String)options.get("world-regex");
            return player.getWorld().getName().matches(worldRegex);
        }
        throw new InvalidConfigurationException("Missing required option: 'worlds' (list of world names), 'world' (single world name) or 'world-regex' (regular expression)");
    }
}

