/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.lib.derkutils;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Cooldown {
    private static final Map<String, Long> COOLDOWNS = new HashMap<String, Long>();

    public static void addCooldown(String identifier, long durationMillis) {
        Objects.requireNonNull(identifier, "Identifier is null");
        COOLDOWNS.put(identifier, System.currentTimeMillis() + durationMillis);
    }

    public static long getCooldown(String identifier) {
        Objects.requireNonNull(identifier, "Identifier is null");
        if (!COOLDOWNS.containsKey(identifier)) {
            return 0L;
        }
        long timeLeft = COOLDOWNS.get(identifier) - System.currentTimeMillis();
        if (timeLeft <= 0L) {
            COOLDOWNS.remove(identifier);
        }
        return timeLeft < 0L ? 0L : timeLeft;
    }

    public static void cleanup() {
        COOLDOWNS.keySet().forEach(Cooldown::getCooldown);
    }
}

