/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.lib.derkutils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;

public class FileUtils {
    public static String getFileName(File file) {
        String name = file.getName();
        int pos = name.lastIndexOf(".");
        if (pos > 0) {
            name = name.substring(0, pos);
        }
        return name;
    }

    public static void copyOutOfJar(Class<?> clazz, String pathToFileInJar, File outputFile) throws IOException {
        Objects.requireNonNull(clazz, "Class is null");
        Objects.requireNonNull(pathToFileInJar, "File path is null");
        Objects.requireNonNull(outputFile, "Output file is null");
        if (!outputFile.exists()) {
            URL inputUrl = clazz.getResource(pathToFileInJar);
            try (InputStream in = inputUrl.openStream();){
                Files.copy(in, outputFile.toPath(), new CopyOption[0]);
            }
        }
    }

    public static void copyOutOfJar(Class<?> clazz, String pathToFileInJar, Path outputFile) throws IOException {
        Objects.requireNonNull(clazz, "Class is null");
        Objects.requireNonNull(pathToFileInJar, "File path is null");
        Objects.requireNonNull(outputFile, "Output file is null");
        if (!Files.exists(outputFile, new LinkOption[0])) {
            try (InputStream in = Objects.requireNonNull(clazz.getClassLoader().getResourceAsStream(pathToFileInJar), "path does not exist in jar: " + pathToFileInJar);){
                Files.copy(in, outputFile, new CopyOption[0]);
            }
        }
    }
}

