/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.lib.derkutils.bukkit;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import nl.rslot.ssx.lib.checkerframework.checker.nullness.qual.NonNull;
import nl.rslot.ssx.lib.checkerframework.checker.nullness.qual.Nullable;
import nl.rslot.ssx.lib.derkutils.bukkit.Colors;
import nl.rslot.ssx.lib.derkutils.bukkit.NbtItemBuilder;
import nl.rslot.ssx.lib.derkutils.bukkit.PlaceholderUtil;
import org.apache.commons.lang.NotImplementedException;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;

public abstract class AbstractItemBuilder<T extends AbstractItemBuilder<T>> {
    protected ItemStack item;

    public AbstractItemBuilder(Material material) {
        this.item = new ItemStack(Objects.requireNonNull(material, "Material is null"));
    }

    public AbstractItemBuilder(ItemStack item) {
        this.item = Objects.requireNonNull(item, "item is null");
    }

    public abstract T getInstance();

    public <M extends ItemMeta> @NonNull T editMeta(Class<M> metaClasss, Consumer<M> metaEditor) {
        @Nullable ItemMeta meta = this.item.getItemMeta();
        metaEditor.accept(meta);
        this.item.setItemMeta(meta);
        return this.getInstance();
    }

    public @NonNull T amount(int amount) {
        this.item.setAmount(amount);
        return this.getInstance();
    }

    public @NonNull T name(@Nullable String name) {
        ItemMeta meta = this.item.getItemMeta();
        meta.setDisplayName(name);
        this.item.setItemMeta(meta);
        return this.getInstance();
    }

    public @NonNull T coloredName(@Nullable String name) {
        ItemMeta meta = this.item.getItemMeta();
        if (name == null) {
            meta.setDisplayName(null);
        } else {
            meta.setDisplayName(Colors.parseColors(name));
        }
        this.item.setItemMeta(meta);
        return this.getInstance();
    }

    public @NonNull T lore(String ... lore) {
        ItemMeta meta = this.item.getItemMeta();
        if (lore == null) {
            meta.setLore(null);
        } else {
            meta.setLore(Arrays.asList(lore));
        }
        this.item.setItemMeta(meta);
        return this.getInstance();
    }

    public @NonNull T coloredLore(String ... lore) {
        ItemMeta meta = this.item.getItemMeta();
        if (lore == null) {
            meta.setLore(null);
        } else {
            meta.setLore(Colors.parseColors(Arrays.asList(lore)));
        }
        this.item.setItemMeta(meta);
        return this.getInstance();
    }

    public @NonNull T lore(@Nullable List<String> lore) {
        ItemMeta meta = this.item.getItemMeta();
        meta.setLore(lore);
        this.item.setItemMeta(meta);
        return this.getInstance();
    }

    public @NonNull T coloredLore(@Nullable List<String> lore) {
        ItemMeta meta = this.item.getItemMeta();
        if (lore == null) {
            meta.setLore(null);
        } else {
            meta.setLore(Colors.parseColors(lore));
        }
        this.item.setItemMeta(meta);
        return this.getInstance();
    }

    public @NonNull T skullOwner(@Nullable String owner) {
        SkullMeta meta = (SkullMeta)this.item.getItemMeta();
        meta.setOwner(owner);
        this.item.setItemMeta((ItemMeta)meta);
        return this.getInstance();
    }

    public @NonNull T leatherArmorColor(@NonNull Color color) {
        Objects.requireNonNull(color, "Color is null");
        LeatherArmorMeta meta = (LeatherArmorMeta)this.item.getItemMeta();
        meta.setColor(color);
        this.item.setItemMeta((ItemMeta)meta);
        return this.getInstance();
    }

    public @NonNull T enchant(@NonNull Enchantment type) {
        return this.enchant(type, 1);
    }

    public @NonNull T enchant(@NonNull Enchantment type, int level) {
        Objects.requireNonNull(type, "Enchantment type is null");
        this.item.addEnchantment(type, level);
        return this.getInstance();
    }

    public @NonNull T unsafeEnchant(@NonNull Enchantment type, int level) {
        Objects.requireNonNull(type, "Enchantment type is null");
        this.item.addUnsafeEnchantment(type, level);
        return this.getInstance();
    }

    public @NonNull T material(Material material) {
        this.item.setType(material == null ? Material.AIR : material);
        return this.getInstance();
    }

    public @NonNull T type(@Nullable Material type) {
        this.item.setType(type == null ? Material.AIR : type);
        return this.getInstance();
    }

    public @NonNull T damage(int durability) {
        this.item.setDurability((short)durability);
        return this.getInstance();
    }

    public @NonNull T namePlaceholder(@NonNull String key, @NonNull String value) {
        Objects.requireNonNull(key, "Placeholder key is null");
        Objects.requireNonNull(value, "Placeholder value is null");
        if (this.item.getItemMeta() == null) {
            return this.getInstance();
        }
        return this.name(this.item.getItemMeta().getDisplayName().replace(key, value));
    }

    public @NonNull T namePlaceholders(@NonNull Map<String, String> placeholders) {
        Objects.requireNonNull(placeholders, "Placeholder map is null");
        if (this.item.getItemMeta() == null) {
            return this.getInstance();
        }
        placeholders.forEach(this::namePlaceholder);
        return this.getInstance();
    }

    public @NonNull T namePlaceholderOptional(@NonNull String key, @NonNull Supplier<String> value) {
        Objects.requireNonNull(key, "Placeholder key is null");
        Objects.requireNonNull(value, "Placeholder value is null");
        if (this.item.getItemMeta() == null) {
            return this.getInstance();
        }
        String oldName = this.item.getItemMeta().getDisplayName();
        if (oldName.contains(key)) {
            return this.name(oldName.replace(key, value.get()));
        }
        return this.getInstance();
    }

    public @NonNull T namePlaceholdersOptional(@NonNull Map<String, Supplier<String>> placeholders) {
        Objects.requireNonNull(placeholders, "Placeholder map is null");
        if (this.item.getItemMeta() == null) {
            return this.getInstance();
        }
        placeholders.forEach(this::namePlaceholderOptional);
        return this.getInstance();
    }

    public @NonNull T lorePlaceholder(@NonNull String key, @NonNull String value) {
        Objects.requireNonNull(key, "Placeholder key is null");
        Objects.requireNonNull(value, "Placeholder value is null");
        if (this.item.getItemMeta() == null || this.item.getItemMeta().getLore() == null) {
            return this.getInstance();
        }
        return this.lore(this.item.getItemMeta().getLore().stream().map(s -> s.replace(key, value)).collect(Collectors.toList()));
    }

    public @NonNull T lorePlaceholders(@NonNull Map<String, String> placeholders) {
        Objects.requireNonNull(placeholders, "Placeholder map is null");
        if (this.item.getItemMeta() == null || this.item.getItemMeta().getLore() == null) {
            return this.getInstance();
        }
        placeholders.forEach(this::lorePlaceholder);
        return this.getInstance();
    }

    public @NonNull T lorePlaceholderOptional(@NonNull String key, @NonNull Supplier<String> value) {
        Objects.requireNonNull(key, "Placeholder key is null");
        Objects.requireNonNull(value, "Placeholder value is null");
        if (this.item.getItemMeta() == null || this.item.getItemMeta().getLore() == null) {
            return this.getInstance();
        }
        return this.lore(this.item.getItemMeta().getLore().stream().map(s -> {
            if (s.contains(key)) {
                return s.replace(key, (CharSequence)value.get());
            }
            return s;
        }).collect(Collectors.toList()));
    }

    public @NonNull T lorePlaceholdersOptional(@NonNull Map<String, Supplier<String>> placeholders) {
        Objects.requireNonNull(placeholders, "Placeholder map is null");
        if (this.item.getItemMeta() == null || this.item.getItemMeta().getLore() == null) {
            return this.getInstance();
        }
        placeholders.forEach(this::lorePlaceholderOptional);
        return this.getInstance();
    }

    public @NonNull T addHideFlags(ItemFlag ... itemFlags) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta == null) {
            throw new IllegalStateException("Item meta is null");
        }
        meta.addItemFlags(itemFlags);
        this.item.setItemMeta(meta);
        return this.getInstance();
    }

    public @NonNull T replaceHideFlags(ItemFlag ... itemFlags) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta == null) {
            throw new IllegalStateException("Item meta is null");
        }
        meta.removeItemFlags(ItemFlag.values());
        meta.addItemFlags(itemFlags);
        this.item.setItemMeta(meta);
        return this.getInstance();
    }

    public T removeHideFlags() {
        ItemMeta meta = this.item.getItemMeta();
        if (meta == null) {
            throw new IllegalStateException("Item meta is null");
        }
        meta.removeItemFlags(ItemFlag.values());
        this.item.setItemMeta(meta);
        return this.getInstance();
    }

    public @NonNull T hideFlags() {
        return this.addHideFlags(ItemFlag.values());
    }

    public @NonNull T hideFlags(boolean hideAllFlags) {
        if (hideAllFlags) {
            return this.hideFlags();
        }
        return this.removeHideFlags();
    }

    public @NonNull T placeholder(@NonNull String key, @NonNull String value) {
        Objects.requireNonNull(key, "Placeholder key is null");
        Objects.requireNonNull(value, "Placeholder value is null");
        return ((AbstractItemBuilder)this.namePlaceholder(key, value)).lorePlaceholder(key, value);
    }

    public @NonNull T placeholders(@NonNull Map<String, String> placeholders) {
        Objects.requireNonNull(placeholders, "Placeholder map is null");
        return ((AbstractItemBuilder)this.namePlaceholders(placeholders)).lorePlaceholders(placeholders);
    }

    public @NonNull T placeholderOptional(@NonNull String key, Supplier<String> value) {
        Objects.requireNonNull(key, "Placeholder key is null");
        Objects.requireNonNull(value, "Placeholder value is null");
        return ((AbstractItemBuilder)this.namePlaceholderOptional(key, value)).lorePlaceholderOptional(key, value);
    }

    public @NonNull T placeholdersOptional(@NonNull Map<String, Supplier<String>> placeholders) {
        Objects.requireNonNull(placeholders, "Placeholder map is null");
        return ((AbstractItemBuilder)this.namePlaceholdersOptional(placeholders)).lorePlaceholdersOptional(placeholders);
    }

    public @NonNull T lorePapi(@NonNull Player player) {
        if (this.item.getItemMeta() == null || this.item.getItemMeta().getLore() == null) {
            return this.getInstance();
        }
        return this.lore(this.item.getItemMeta().getLore().stream().map(s -> PlaceholderUtil.parsePapiPlaceholders(player, s)).collect(Collectors.toList()));
    }

    public @NonNull T namePapi(@NonNull Player player) {
        if (this.item.getItemMeta() == null) {
            return this.getInstance();
        }
        return this.name(PlaceholderUtil.parsePapiPlaceholders(player, this.item.getItemMeta().getDisplayName()));
    }

    public @NonNull T papi(@NonNull Player player) {
        Objects.requireNonNull(player, "Player is null");
        this.namePapi(player);
        return this.lorePapi(player);
    }

    public @NonNull NbtItemBuilder skullTexture(@NonNull String texture) {
        throw new NotImplementedException("Only implemented in NbtItemBuilder");
    }

    public @NonNull ItemStack create() {
        return this.item;
    }
}

