/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.lib.derkutils.bukkit;

import java.util.Arrays;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import nl.rslot.ssx.lib.checkerframework.checker.nullness.qual.NonNull;
import nl.rslot.ssx.lib.derkutils.bukkit.AbstractItemBuilder;
import nl.rslot.ssx.lib.nbtapi.NBT;
import nl.rslot.ssx.lib.nbtapi.iface.ReadWriteItemNBT;
import nl.rslot.ssx.lib.nbtapi.iface.ReadWriteNBT;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class NbtItemBuilder
extends AbstractItemBuilder<NbtItemBuilder> {
    public NbtItemBuilder(@NonNull Material material) {
        super(material);
    }

    public NbtItemBuilder(@NonNull ItemStack item) {
        super(item);
    }

    @Override
    public @NonNull NbtItemBuilder getInstance() {
        return this;
    }

    public @NonNull NbtItemBuilder canDestroy(String ... vanillaNamespacedNames) {
        Objects.requireNonNull(vanillaNamespacedNames, "names varargs is null");
        NBT.modify(this.item, nbt -> nbt.getStringList("CanDestroy").addAll(Arrays.asList(vanillaNamespacedNames)));
        return this;
    }

    public @NonNull NbtItemBuilder canPlaceOn(String ... vanillaNamespacedNames) {
        Objects.requireNonNull(vanillaNamespacedNames, "names varargs is null");
        NBT.modify(this.item, nbt -> nbt.getStringList("CanPlaceOn").addAll(Arrays.asList(vanillaNamespacedNames)));
        return this;
    }

    @Override
    public @NonNull NbtItemBuilder skullTexture(@NonNull String texture) {
        Objects.requireNonNull(texture, "Texture string is null");
        this.editNbt(nbt -> {
            ReadWriteNBT skullOwner = nbt.getOrCreateCompound("SkullOwner");
            skullOwner.setString("Id", UUID.randomUUID().toString());
            skullOwner.getOrCreateCompound("Properties").getCompoundList("textures").addCompound().setString("Value", texture);
        });
        return this;
    }

    @Deprecated
    public @NonNull NbtItemBuilder hideFlags(int hideFlags) {
        NBT.modify(this.item, nbt -> nbt.setInteger("HideFlags", hideFlags));
        return this;
    }

    public @NonNull NbtItemBuilder editNbt(@NonNull Consumer<ReadWriteItemNBT> nbtModifier) {
        NBT.modify(this.item, nbtModifier);
        return this;
    }
}

