/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.lib.derkutils.bukkit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import nl.rslot.ssx.lib.checkerframework.checker.nullness.qual.NonNull;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PlaceholderUtil {
    private static Method papiParseString = null;
    private static Method papiParseList = null;

    public static @NonNull String parsePlaceholders(@NonNull String string, Placeholder ... placeholders) {
        Objects.requireNonNull(string, "input string must not be null");
        Objects.requireNonNull(placeholders, "placeholders varargs is null");
        for (Placeholder p : placeholders) {
            string = Objects.requireNonNull(p, "a placeholder is null").parse(string);
        }
        return string;
    }

    public static @NonNull String parsePlaceholders(@NonNull String string, @NonNull Collection<Placeholder> placeholders) {
        Objects.requireNonNull(string, "input string must not be null");
        Objects.requireNonNull(placeholders, "placeholders collection is null");
        for (Placeholder p : placeholders) {
            string = Objects.requireNonNull(p, "a placeholder is null").parse(string);
        }
        return string;
    }

    public static @NonNull List<String> parsePlaceholders(@NonNull List<String> strings, Placeholder ... placeholders) {
        Objects.requireNonNull(strings, "strings list is null");
        Objects.requireNonNull(placeholders, "placeholders array is null");
        for (Placeholder p : placeholders) {
            strings = Objects.requireNonNull(p, "a placeholder is null").parse(strings);
        }
        return strings;
    }

    public static @NonNull List<String> parsePlaceholders(@NonNull List<String> strings, @NonNull Collection<Placeholder> placeholders) {
        Objects.requireNonNull(strings, "strings list is null");
        Objects.requireNonNull(placeholders, "placeholders collection is null");
        for (Placeholder p : placeholders) {
            strings = Objects.requireNonNull(p, "a placeholder is null").parse(strings);
        }
        return strings;
    }

    public static @NonNull String parsePapiPlaceholders(@NonNull Player player, @NonNull String string, Placeholder ... placeholders) {
        Objects.requireNonNull(player, "Player must not be null");
        Objects.requireNonNull(string, "Input string must not be null");
        Objects.requireNonNull(placeholders, "Placeholders varargs is null");
        for (Placeholder p : placeholders) {
            string = Objects.requireNonNull(p, "a placeholder is null").parse(string);
        }
        string = PlaceholderUtil.parsePapiPlaceholders(player, string);
        return string;
    }

    public static @NonNull String parsePapiPlaceholders(@NonNull Player player, @NonNull String string, @NonNull Collection<Placeholder> placeholders) {
        Objects.requireNonNull(player, "Player must not be null");
        Objects.requireNonNull(string, "Input string must not be null");
        Objects.requireNonNull(placeholders, "Placeholders collection is null");
        for (Placeholder p : placeholders) {
            string = Objects.requireNonNull(p, "a placeholder is null").parse(string);
        }
        string = PlaceholderUtil.parsePapiPlaceholders(player, string);
        return string;
    }

    public static @NonNull List<@NonNull String> parsePapiPlaceholders(@NonNull Player player, @NonNull List<@NonNull String> strings, Placeholder ... placeholders) {
        Objects.requireNonNull(player, "Player must not be null");
        Objects.requireNonNull(placeholders, "Placeholders array is null");
        for (Placeholder p : placeholders) {
            strings = Objects.requireNonNull(p, "A placeholder is null").parse(strings);
        }
        strings = PlaceholderUtil.parsePapiPlaceholders(player, strings);
        return strings;
    }

    public static @NonNull List<@NonNull String> parsePapiPlaceholders(@NonNull Player player, @NonNull List<@NonNull String> strings, @NonNull Collection<Placeholder> placeholders) {
        Objects.requireNonNull(player, "Player must not be null");
        Objects.requireNonNull(placeholders, "Placeholders collection is null");
        for (Placeholder p : placeholders) {
            strings = Objects.requireNonNull(p, "A placeholder is null").parse(strings);
        }
        strings = PlaceholderUtil.parsePapiPlaceholders(player, strings);
        return strings;
    }

    public static @NonNull String parsePapiPlaceholders(@NonNull Player player, @NonNull String string) {
        Objects.requireNonNull(player, "Player must not be null");
        Objects.requireNonNull(string, "Provided string must not be null");
        if (papiParseString == null) {
            return string;
        }
        try {
            return (String)papiParseString.invoke(null, player, string);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return string;
        }
    }

    public static @NonNull List<String> parsePapiPlaceholders(@NonNull Player player, @NonNull List<String> strings) {
        Objects.requireNonNull(player, "Player must not be null");
        Objects.requireNonNull(strings, "Provided string list must not be null");
        if (papiParseList == null) {
            return strings;
        }
        try {
            return (List)papiParseList.invoke(null, player, strings);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return strings;
        }
    }

    static {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                Class<?> c = Class.forName("me.clip.placeholderapi.PlaceholderAPI");
                papiParseString = c.getMethod("setPlaceholders", Player.class, String.class);
                papiParseList = c.getMethod("setPlaceholders", Player.class, List.class);
            }
            catch (ClassNotFoundException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
            }
        }
    }

    public static class Placeholder {
        private final @NonNull String key;
        private final @NonNull String value;

        public Placeholder(@NonNull String key, @NonNull String value) {
            this.key = Objects.requireNonNull(key, "Placeholder key is null");
            this.value = Objects.requireNonNull(value, "Placeholder value is null");
        }

        public @NonNull String parse(@NonNull String string) {
            return string.replace(this.key, this.value);
        }

        public @NonNull List<String> parse(@NonNull List<String> list) {
            return list.stream().map(this::parse).collect(Collectors.toList());
        }
    }
}

