/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.lib.kyori.adventure.text;

import java.util.Objects;
import nl.rslot.ssx.lib.jetbrains-annotations.NotNull;
import nl.rslot.ssx.lib.jetbrains-annotations.Nullable;
import nl.rslot.ssx.lib.kyori.adventure.text.AbstractComponentBuilder;
import nl.rslot.ssx.lib.kyori.adventure.text.Component;
import nl.rslot.ssx.lib.kyori.adventure.text.ComponentLike;
import nl.rslot.ssx.lib.kyori.adventure.text.NBTComponent;
import nl.rslot.ssx.lib.kyori.adventure.text.NBTComponentBuilder;

abstract class AbstractNBTComponentBuilder<C extends NBTComponent<C, B>, B extends NBTComponentBuilder<C, B>>
extends AbstractComponentBuilder<C, B>
implements NBTComponentBuilder<C, B> {
    @Nullable
    protected String nbtPath;
    protected boolean interpret = false;
    @Nullable
    protected Component separator;

    AbstractNBTComponentBuilder() {
    }

    AbstractNBTComponentBuilder(@NotNull C component) {
        super(component);
        this.nbtPath = component.nbtPath();
        this.interpret = component.interpret();
        this.separator = component.separator();
    }

    @Override
    @NotNull
    public B nbtPath(@NotNull String nbtPath) {
        this.nbtPath = Objects.requireNonNull(nbtPath, "nbtPath");
        return (B)this;
    }

    @Override
    @NotNull
    public B interpret(boolean interpret) {
        this.interpret = interpret;
        return (B)this;
    }

    @Override
    @NotNull
    public B separator(@Nullable ComponentLike separator) {
        this.separator = ComponentLike.unbox(separator);
        return (B)this;
    }
}

