/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.placeholders;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import nl.rslot.ssx.Main;
import nl.rslot.ssx.lib.checkerframework.checker.nullness.qual.Nullable;
import nl.rslot.ssx.placeholders.GlobalPlaceholder;
import nl.rslot.ssx.placeholders.Placeholder;
import nl.rslot.ssx.placeholders.PlayerPlaceholder;
import nl.rslot.ssx.placeholders.Server;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlaceholderReceiver {
    private Map<String, Server> servers = Collections.emptyMap();
    private String status;
    private long lastSuccess = 0L;
    private List<String> placeholderServers;
    private String networkId;
    private final String lobbyId;

    public PlaceholderReceiver() {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Main.getPlugin(), this::updatePlaceholders, 0L, 100L);
        this.lobbyId = UUID.randomUUID().toString();
    }

    public String getStatus() {
        return this.status;
    }

    public void loadConfiguration() {
        FileConfiguration config = Main.getConfigurationManager().getServerConfiguration();
        this.placeholderServers = config.getStringList("placeholder-servers");
        this.networkId = config.getString("network-id");
    }

    public void updatePlaceholders() {
        if (this.placeholderServers.size() == 0 || this.networkId == null) {
            return;
        }
        String newStatus = "";
        for (String placeholderServer : this.placeholderServers) {
            try {
                this.updatePlaceholdersFrom(placeholderServer);
                this.lastSuccess = System.currentTimeMillis();
                newStatus = newStatus + ChatColor.GRAY + placeholderServer + ChatColor.GREEN + " WORKING" + ChatColor.RESET + "\n";
                break;
            }
            catch (Exception e) {
                newStatus = newStatus + ChatColor.GRAY + placeholderServer + ChatColor.RED + " " + e.getClass().getSimpleName() + ": " + e.getMessage() + ChatColor.RESET + "\n";
            }
        }
        this.status = newStatus;
        if (System.currentTimeMillis() - this.lastSuccess > 300000L) {
            this.servers = Collections.emptyMap();
        }
    }

    public void updatePlaceholdersFrom(String placeholderServer) throws IOException {
        JsonArray jsonPlayersArray = new JsonArray();
        for (Player player : Bukkit.getOnlinePlayers()) {
            jsonPlayersArray.add((JsonElement)new JsonPrimitive(player.getUniqueId().toString()));
        }
        JsonObject requestJson = new JsonObject();
        requestJson.add("players", (JsonElement)jsonPlayersArray);
        requestJson.addProperty("network", this.networkId);
        requestJson.addProperty("lobby", this.lobbyId);
        URLConnection connection = URI.create(placeholderServer + "/lobby").toURL().openConnection();
        connection.setDoOutput(true);
        try (OutputStream out = connection.getOutputStream();){
            byte[] data = requestJson.toString().getBytes();
            out.write(data);
        }
        var6_6 = null;
        try (InputStream in = connection.getInputStream();
             InputStreamReader reader = new InputStreamReader(in);){
            JsonObject repsonseJson = Main.JSON_PARSER.parse((Reader)reader).getAsJsonObject();
            this.servers = PlaceholderReceiver.parseResponse(repsonseJson);
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
    }

    public Map<String, Server> getServers() {
        return this.servers;
    }

    public @Nullable Server getServer(String name) {
        return this.servers.get(name);
    }

    private static Map<String, Server> parseResponse(JsonObject response) {
        JsonObject serversObject = response.get("servers").getAsJsonObject();
        HashMap<String, Server> newServers = new HashMap<String, Server>();
        for (Map.Entry entry : serversObject.entrySet()) {
            String serverName = (String)entry.getKey();
            JsonObject serverObject = ((JsonElement)entry.getValue()).getAsJsonObject();
            JsonObject placeholdersObject = serverObject.get("placeholders").getAsJsonObject();
            HashMap<String, Placeholder> parsedPlaceholders = new HashMap<String, Placeholder>();
            for (Map.Entry placeholderEntry : placeholdersObject.entrySet()) {
                String key = (String)placeholderEntry.getKey();
                if (((JsonElement)placeholderEntry.getValue()).isJsonObject()) {
                    JsonObject values = ((JsonElement)placeholderEntry.getValue()).getAsJsonObject();
                    HashMap<UUID, String> parsedValues = new HashMap<UUID, String>();
                    for (Map.Entry valueEntry : values.entrySet()) {
                        parsedValues.put(UUID.fromString((String)valueEntry.getKey()), ((JsonElement)valueEntry.getValue()).getAsString());
                    }
                    parsedPlaceholders.put(key, new PlayerPlaceholder(key, parsedValues));
                    continue;
                }
                if (!((JsonElement)placeholderEntry.getValue()).isJsonPrimitive()) continue;
                String value = ((JsonElement)placeholderEntry.getValue()).getAsString();
                parsedPlaceholders.put(key, new GlobalPlaceholder(key, value));
            }
            newServers.put(serverName, new Server(serverName, parsedPlaceholders));
        }
        return newServers;
    }
}

