/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.connector;

import java.io.File;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import nl.rslot.ssx.connector.Main;
import nl.rslot.ssx.connector.PlaceholderRegistry;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public abstract class Addon
implements Listener {
    protected final JavaPlugin plugin = Main.instance;
    protected FileConfiguration config;

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public abstract String getDescription();

    public abstract String getAuthor();

    public abstract String getVersion();

    public abstract void onLoad();

    protected void registerListeners() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    protected void addPlaceholder(String key, Supplier<String> valueSupplier) {
        PlaceholderRegistry.registerPlaceholder(Optional.of(this), key, valueSupplier);
    }

    protected void addPlayerPlaceholder(String key, Function<UUID, String> valueFunction) {
        PlaceholderRegistry.registerPlaceholder(Optional.of(this), key, valueFunction);
    }

    void reloadConfig() {
        File file = new File(Main.instance.addonsFolder, this.getName() + ".yml");
        if (file.exists()) {
            this.config = YamlConfiguration.loadConfiguration((File)file);
        }
    }
}

