/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.connector;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import nl.rslot.ssx.connector.Addon;
import nl.rslot.ssx.connector.ConnectorCommand;
import nl.rslot.ssx.connector.PlaceholderRegistry;
import nl.rslot.ssx.connector.PlaceholderSender;
import nl.rslot.ssx.connector.bstats.bukkit.Metrics;
import nl.rslot.ssx.connector.bstats.charts.AdvancedPie;
import nl.rslot.ssx.connector.bstats.charts.SimplePie;
import nl.rslot.ssx.connector.scheduler.AbstractScheduledTask;
import nl.rslot.ssx.connector.scheduler.BukkitSchedulerWrapper;
import nl.rslot.ssx.connector.scheduler.FoliaSchedulerWrapper;
import nl.rslot.ssx.connector.scheduler.SchedulerWrapper;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    static Main instance;
    private SchedulerWrapper scheduler;
    final File addonsFolder = new File(this.getDataFolder(), "addons");
    Map<String, Addon> addons = new HashMap<String, Addon>();
    private AbstractScheduledTask pingTask = null;

    public void onEnable() {
        boolean isFolia;
        instance = this;
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            isFolia = true;
        }
        catch (ClassNotFoundException e) {
            isFolia = false;
        }
        this.scheduler = isFolia ? new FoliaSchedulerWrapper((Plugin)this) : new BukkitSchedulerWrapper((Plugin)this);
        super.saveDefaultConfig();
        this.addonsFolder.mkdir();
        this.loadAddons();
        this.getCommand("ssxc").setExecutor((CommandExecutor)new ConnectorCommand());
        this.restartPingTask();
        this.registerMetrics();
    }

    public SchedulerWrapper getScheduler() {
        return this.scheduler;
    }

    void loadAddons() {
        PlaceholderRegistry.clear();
        File addonsFolder = new File(this.getDataFolder() + File.separator + "addons");
        addonsFolder.mkdirs();
        HashSet<String> newlyLoadedAddons = new HashSet<String>();
        for (File addonFile : addonsFolder.listFiles()) {
            if (addonFile.isDirectory()) {
                this.getLogger().warning("Skipped directory " + addonFile.getPath() + " in addons directory. There should not be any directories in the addon directory.");
                continue;
            }
            if (!addonFile.getName().endsWith(".class")) {
                if (addonFile.getName().endsWith(".yml")) continue;
                this.getLogger().warning("The file " + addonFile.getAbsolutePath() + " does not belong in the addons folder.");
                continue;
            }
            String addonName = addonFile.getName().replace(".class", "");
            Addon addon = this.addons.get(addonName);
            if (addon == null) {
                this.getLogger().info("Loading addon " + addonName);
                try (URLClassLoader loader = new URLClassLoader(new URL[]{addonsFolder.toURI().toURL()}, this.getClassLoader());){
                    Class<?> clazz = loader.loadClass(addonFile.getName().replace(".class", ""));
                    addon = (Addon)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    e.printStackTrace();
                    continue;
                }
            }
            if (!addon.getName().equals(addonName)) {
                this.getLogger().severe(String.format("Addon class name (%s) does not match class file name (%s)", addon.getName(), addonName));
                continue;
            }
            addon.reloadConfig();
            addon.onLoad();
            this.addons.put(addonName, addon);
            newlyLoadedAddons.add(addonName);
        }
        ArrayDeque<String> toRemove = new ArrayDeque<String>();
        for (String addonName : this.addons.keySet()) {
            if (newlyLoadedAddons.contains(addonName)) continue;
            this.getLogger().info("Uninstalling addon " + addonName);
            toRemove.add(addonName);
        }
        while (!toRemove.isEmpty()) {
            this.addons.remove(toRemove.pop());
        }
        this.registerCorePlaceholders();
    }

    void registerCorePlaceholders() {
        PlaceholderRegistry.registerPlaceholder(Optional.empty(), "online", () -> String.valueOf(Bukkit.getOnlinePlayers().size()));
        PlaceholderRegistry.registerPlaceholder(Optional.empty(), "max", () -> String.valueOf(Bukkit.getMaxPlayers()));
        String bukkitVersion = Bukkit.getBukkitVersion();
        String humanVersion = bukkitVersion.substring(0, bukkitVersion.indexOf("-"));
        PlaceholderRegistry.registerPlaceholder(Optional.empty(), "version", () -> humanVersion);
    }

    void restartPingTask() {
        if (this.pingTask != null) {
            this.pingTask.cancel();
        }
        int intervalTicks = this.getConfig().getInt("send-interval") * 20;
        this.pingTask = this.getScheduler().runTimer(new PlaceholderSender(), 0, intervalTicks);
    }

    private void registerMetrics() {
        Metrics metrics = new Metrics((Plugin)this, 3000);
        metrics.addCustomChart(new SimplePie("data_send_interval", () -> this.getConfig().getInt("send-interval", 4) + ""));
        metrics.addCustomChart(new SimplePie("hub_servers", () -> this.getConfig().getStringList("addresses").size() + ""));
        metrics.addCustomChart(new SimplePie("default_password", () -> this.getConfig().getString("password").equals("a") + ""));
        metrics.addCustomChart(new AdvancedPie("addons", () -> {
            HashMap map = new HashMap();
            this.addons.forEach((ign, a) -> map.put(a.getName(), 1));
            return map;
        }));
    }

    public List<String> addresses() {
        List addresses = this.getConfig().getStringList("addresses");
        if (addresses.isEmpty()) {
            return Collections.emptyList();
        }
        return addresses.stream().map(String::trim).map(s -> !s.startsWith("https://") && !s.startsWith("http://") ? "http://" + s : s).collect(Collectors.toList());
    }
}

