/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.connector;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import nl.rslot.ssx.connector.Addon;

public class PlaceholderRegistry {
    private static final List<Placeholder> PLACEHOLDERS = new ArrayList<Placeholder>();

    public static void registerPlaceholder(Optional<Addon> addon, String key, Function<UUID, String> valueFunction) {
        PLACEHOLDERS.add(new PlayerPlaceholder(key, addon, valueFunction));
    }

    public static void registerPlaceholder(Optional<Addon> addon, String key, Supplier<String> valueSupplier) {
        PLACEHOLDERS.add(new GlobalPlaceholder(key, addon, valueSupplier));
    }

    public static void unregisterAddonPlaceholders(Addon addon) {
        ArrayList keysToRemove = new ArrayList();
        PLACEHOLDERS.stream().filter(p -> p.getAddon() == addon).forEach(keysToRemove::add);
        keysToRemove.forEach(PLACEHOLDERS::remove);
    }

    public static void clear() {
        PLACEHOLDERS.clear();
    }

    public static List<Placeholder> getPlaceholders() {
        return PLACEHOLDERS;
    }

    public static abstract class Placeholder {
        private final String key;
        private final Optional<Addon> addon;

        private Placeholder(String key, Optional<Addon> addon) {
            this.key = key;
            this.addon = addon;
        }

        public String getKey() {
            return this.key;
        }

        public boolean isFromAddon() {
            return this.addon.isPresent();
        }

        public Addon getAddon() {
            return this.addon.get();
        }
    }

    public static class GlobalPlaceholder
    extends Placeholder {
        private final Supplier<String> valueSupplier;

        private GlobalPlaceholder(String key, Optional<Addon> addon, Supplier<String> valueSupplier) {
            super(key, addon);
            this.valueSupplier = valueSupplier;
        }

        public String getValue() {
            return this.valueSupplier.get();
        }
    }

    public static class PlayerPlaceholder
    extends Placeholder {
        private final Function<UUID, String> function;

        private PlayerPlaceholder(String key, Optional<Addon> addon, Function<UUID, String> function) {
            super(key, addon);
            this.function = function;
        }

        public String getValue(UUID uuid) {
            return this.function.apply(uuid);
        }
    }
}

