/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.connector;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import nl.rslot.ssx.connector.Main;
import nl.rslot.ssx.connector.PingLogger;
import nl.rslot.ssx.connector.PlaceholderRegistry;
import org.bukkit.configuration.file.FileConfiguration;

public class PlaceholderSender
implements Runnable {
    private Set<UUID> playerUuids;

    @Override
    public void run() {
        JsonObject placeholdersJson = new JsonObject();
        for (PlaceholderRegistry.Placeholder placeholder : PlaceholderRegistry.getPlaceholders()) {
            String key = placeholder.getKey();
            try {
                if (placeholder instanceof PlaceholderRegistry.PlayerPlaceholder) {
                    JsonObject valuesObject = new JsonObject();
                    for (UUID uuid : this.playerUuids) {
                        String value = ((PlaceholderRegistry.PlayerPlaceholder)placeholder).getValue(uuid);
                        if (value == null) continue;
                        valuesObject.addProperty(key, value);
                    }
                    placeholdersJson.add(key, (JsonElement)valuesObject);
                    continue;
                }
                String value = ((PlaceholderRegistry.GlobalPlaceholder)placeholder).getValue();
                if (value == null) continue;
                placeholdersJson.addProperty(key, value);
            }
            catch (Exception e) {
                Main.instance.getLogger().warning("An error occured while retrieving placeholder " + key + ". This is probably a bug in the plugin or expansion that added this placeholder (not in SSX-Connector).");
                Main.instance.getLogger().warning("Note that not all plugins work properly when no players are online on a server.");
                e.printStackTrace();
            }
        }
        Main.instance.getScheduler().runAsync(() -> {
            FileConfiguration config = Main.instance.getConfig();
            String networkId = config.getString("network-id");
            String serverName = config.getString("server-name");
            List addresses = config.getStringList("placeholder-servers");
            if (networkId == null || networkId.isEmpty()) {
                this.debug("network-id is not configured");
                return;
            }
            if (serverName == null || serverName.isEmpty()) {
                this.debug("server-name is not configured");
                return;
            }
            this.debug("server-name = " + serverName);
            this.debug("players: " + String.join((CharSequence)(", " + this.playerUuids), new CharSequence[0]));
            JsonObject json = new JsonObject();
            json.addProperty("network", networkId);
            json.addProperty("server", serverName);
            json.add("placeholders", (JsonElement)placeholdersJson);
            String jsonString = json.toString();
            this.debug("sending json: " + jsonString);
            byte[] data = jsonString.getBytes();
            this.sendPlaceholders(addresses, data);
        });
    }

    private void sendPlaceholders(List<String> addresses, byte[] data) {
        HashSet<UUID> players = new HashSet<UUID>();
        for (String address : addresses) {
            try {
                String[] partialPlayers;
                for (String uuidString : partialPlayers = this.sendPlaceholdersTo(address, data)) {
                    players.add(UUID.fromString(uuidString));
                }
                PingLogger.logSuccess(address);
                this.debug("data sent to: " + address);
            }
            catch (IOException e) {
                PingLogger.logFail(address, "IOException: " + e.getMessage());
                this.debug(e);
            }
        }
        this.playerUuids = players;
    }

    private String[] sendPlaceholdersTo(String address, byte[] data) throws IOException {
        JsonObject responseJson;
        HttpURLConnection connection = (HttpURLConnection)URI.create(address + "/connector").toURL().openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        connection.setConnectTimeout(1000);
        connection.setReadTimeout(1000);
        try (OutputStream out = connection.getOutputStream();){
            out.write(data);
        }
        if (connection.getResponseCode() != 200) {
            throw new IOException("Response code " + connection.getResponseCode());
        }
        try (InputStream in = connection.getInputStream();
             InputStreamReader reader = new InputStreamReader(in);){
            responseJson = new JsonParser().parse((Reader)reader).getAsJsonObject();
        }
        JsonArray jsonPlayersArray = responseJson.get("players").getAsJsonArray();
        String[] players = new String[jsonPlayersArray.size()];
        for (int i = 0; i < jsonPlayersArray.size(); ++i) {
            players[i] = jsonPlayersArray.get(i).getAsString();
        }
        return players;
    }

    private void debug(String message) {
        if (Main.instance.getConfig().getBoolean("debug", false)) {
            Main.instance.getLogger().info("[Debug] " + message);
        }
    }

    private void debug(Exception e) {
        if (Main.instance.getConfig().getBoolean("debug", false)) {
            e.printStackTrace();
        }
    }
}

