/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.connector.scheduler;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Consumer;
import nl.rslot.ssx.connector.scheduler.FoliaScheduledTask;
import nl.rslot.ssx.connector.scheduler.SchedulerWrapper;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;

public class FoliaSchedulerWrapper
implements SchedulerWrapper {
    private final Plugin plugin;
    private final Object asyncScheduler;
    private final Object globalRegionScheduler;
    private final Method asyncRunNowMethod;
    private final Method runTimerMethod;

    public FoliaSchedulerWrapper(Plugin plugin) {
        try {
            this.plugin = plugin;
            Server server = Bukkit.getServer();
            this.asyncScheduler = server.getClass().getMethod("getAsyncScheduler", new Class[0]).invoke((Object)server, new Object[0]);
            this.asyncRunNowMethod = this.asyncScheduler.getClass().getMethod("runNow", Plugin.class, Consumer.class);
            this.globalRegionScheduler = server.getClass().getMethod("getGlobalRegionScheduler", new Class[0]).invoke((Object)server, new Object[0]);
            this.runTimerMethod = this.globalRegionScheduler.getClass().getMethod("runAtFixedRate", Plugin.class, Consumer.class, Long.TYPE, Long.TYPE);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public FoliaScheduledTask runAsync(Runnable runnable) {
        try {
            Consumer<Object> task = task2 -> runnable.run();
            return new FoliaScheduledTask(this.asyncRunNowMethod.invoke(this.asyncScheduler, this.plugin, task));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public FoliaScheduledTask runTimer(Runnable runnable, int delay, int interval) {
        delay = delay > 0 ? delay : 1;
        try {
            Consumer<Object> task = task2 -> runnable.run();
            return new FoliaScheduledTask(this.runTimerMethod.invoke(this.globalRegionScheduler, this.plugin, task, delay, interval));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

