/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx;

import java.util.List;
import java.util.Objects;
import nl.rslot.ssx.Main;
import nl.rslot.ssx.actions.Action;
import nl.rslot.ssx.lib.derkutils.Cooldown;
import nl.rslot.ssx.lib.derkutils.bukkit.Colors;
import nl.rslot.ssx.lib.derkutils.bukkit.reflection.ReflectionUtil;
import nl.rslot.ssx.lib.jetbrains-annotations.NotNull;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class Commands {
    static void registerCustomCommands() {
        CommandMap commandMap = ReflectionUtil.getCommandMap();
        for (final String commandName : Main.getConfigurationManager().listCommandConfigurations()) {
            final FileConfiguration config = Main.getConfigurationManager().getCommandConfiguration(commandName);
            String description = Objects.requireNonNull(config.getString("description", "Opens menu"));
            String usage = Objects.requireNonNull(config.getString("usage", "/<command>"));
            List aliases = config.getStringList("aliases");
            final List actions = config.getStringList("actions");
            if (commandMap.getCommand(commandName) != null) {
                Main.getPlugin().getLogger().warning("Skipped registering command /" + commandName + ", it already exists.");
                continue;
            }
            commandMap.register("ssx-custom", new Command(commandName, description, usage, aliases){

                public boolean execute(@NotNull CommandSender sender, @NotNull String label, String[] args) {
                    if (sender instanceof Player) {
                        Player player = (Player)sender;
                        FileConfiguration configMisc = Main.getConfigurationManager().getMiscConfiguration();
                        if (config.isInt("cooldown")) {
                            long timeLeft = Cooldown.getCooldown("ssxcommand" + commandName);
                            if (timeLeft > 0L) {
                                String cooldownMessage = configMisc.getString("cooldown-message");
                                if (cooldownMessage != null) {
                                    player.sendMessage(Colors.parseColors(String.format(cooldownMessage, (double)timeLeft / 1000.0)));
                                }
                                return true;
                            }
                            Cooldown.addCooldown("ssxcommand" + commandName, config.getInt("cooldown"));
                        }
                        if (config.getBoolean("permission", false) && !player.hasPermission("ssx.command." + commandName)) {
                            String permissionMessage = configMisc.getString("no-permission");
                            if (permissionMessage != null) {
                                player.sendMessage(Colors.parseColors(permissionMessage));
                            }
                            return true;
                        }
                        Action.runActions(player, actions);
                    }
                    return true;
                }
            });
        }
    }
}

