/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx;

import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import nl.rslot.ssx.Main;
import nl.rslot.ssx.lib.checkerframework.checker.nullness.qual.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Heads {
    private final Map<String, HeadHandler> handlers;

    Heads(JavaPlugin plugin) {
        block5: {
            Logger logger;
            block4: {
                this.handlers = new HashMap<String, HeadHandler>();
                logger = plugin.getLogger();
                try {
                    this.handlers.put("arc-hdb", new ArcaniaxHandler());
                    logger.info("Integration with Arcaniax's Head Database plugin is active");
                }
                catch (Exception e) {
                    if (!Main.getConfigurationManager().getMiscConfiguration().getBoolean("head-api-debug")) break block4;
                    e.printStackTrace();
                }
            }
            try {
                this.handlers.put("silent-hdb", new SilentHandler());
                logger.info("Integration with TheSilentPro's Head Database plugin is active");
            }
            catch (Exception e) {
                if (!Main.getConfigurationManager().getMiscConfiguration().getBoolean("head-api-debug")) break block5;
                e.printStackTrace();
            }
        }
        this.handlers.put("uuid", new UuidHandler(plugin));
        this.handlers.put("texture", new TextureLiteralHandler());
        this.handlers.put("url", new TextureURLHandler());
    }

    public CompletableFuture<@Nullable String> getHead(String identifier) throws InvalidConfigurationException {
        int index = identifier.indexOf(":");
        if (index == -1) {
            throw new InvalidConfigurationException("Invalid head '" + identifier + "'. Valid syntax is 'head:<type>:<value>' or 'head:self'.");
        }
        String type = identifier.substring(0, index);
        String value = identifier.substring(index + 1);
        if (!this.handlers.containsKey(type)) {
            throw new InvalidConfigurationException("Invalid head type: " + type);
        }
        return this.handlers.get(type).getHeadTexture(value);
    }

    private static class TextureURLHandler
    implements HeadHandler {
        private TextureURLHandler() {
        }

        @Override
        public CompletableFuture<@Nullable String> getHeadTexture(String textureUrl) {
            JsonObject skinTextureJson = new JsonObject();
            JsonObject textures = new JsonObject();
            skinTextureJson.add("textures", textures);
            JsonObject skin = new JsonObject();
            textures.add("SKIN", skin);
            skin.addProperty("url", textureUrl);
            return CompletableFuture.completedFuture(skinTextureJson.toString());
        }
    }

    private static class TextureLiteralHandler
    implements HeadHandler {
        private TextureLiteralHandler() {
        }

        @Override
        public CompletableFuture<@Nullable String> getHeadTexture(String textureString) {
            return CompletableFuture.completedFuture(textureString);
        }
    }

    private static class UuidHandler
    implements HeadHandler {
        private final JavaPlugin plugin;
        private final Map<String, String> cachedTextures = new HashMap<String, String>();

        private UuidHandler(JavaPlugin plugin) {
            this.plugin = plugin;
        }

        @Override
        public CompletableFuture<@Nullable String> getHeadTexture(String name) {
            String cachedTexture = this.cachedTextures.get(name);
            if (cachedTexture != null) {
                return CompletableFuture.completedFuture(cachedTexture);
            }
            CompletableFuture<String> future = new CompletableFuture<String>();
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
                UUID uuid = UUID.fromString(name);
                Main.getPlugin().getLogger().info("Getting texture value for " + String.valueOf(uuid) + " from Mojang API");
                try {
                    HttpURLConnection connection = (HttpURLConnection)URI.create("https://sessionserver.mojang.com/session/minecraft/profile/" + String.valueOf(uuid)).toURL().openConnection();
                    try (InputStreamReader reader = new InputStreamReader(connection.getInputStream());){
                        JsonObject jsonResponse = Main.JSON_PARSER.parse(reader).getAsJsonObject();
                        String texture = jsonResponse.get("properties").getAsJsonArray().get(0).getAsJsonObject().get("value").getAsString();
                        this.cachedTextures.put(name, texture);
                        future.complete(texture);
                    }
                }
                catch (Exception e) {
                    future.completeExceptionally(e);
                }
            });
            return future;
        }
    }

    private static class SilentHandler
    implements HeadHandler {
        private final Method getHeadByIdMethod;
        private final Method getValueMethod;

        private SilentHandler() throws Exception {
            Class<?> apiClass = Class.forName("tsp.headdb.api.HeadAPI");
            this.getHeadByIdMethod = apiClass.getMethod("getHeadByID", new Class[0]);
            Class<?> headClass = Class.forName("tsp.headdb.implementation.Head");
            this.getValueMethod = headClass.getMethod("getValue", new Class[0]);
        }

        @Override
        public CompletableFuture<@Nullable String> getHeadTexture(String name) {
            CompletableFuture<String> future = new CompletableFuture<String>();
            try {
                Object headInstance = this.getHeadByIdMethod.invoke(null, new Object[0]);
                String texture = (String)this.getValueMethod.invoke(headInstance, new Object[0]);
                future.complete(texture);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
            return future;
        }
    }

    private static class ArcaniaxHandler
    implements HeadHandler {
        private final Object apiInstance;
        private final Method getBase64Method;

        private ArcaniaxHandler() throws Exception {
            Class<?> apiClass = Class.forName("me.arcaniax.hdb.api.HeadDatabaseAPI");
            Constructor<?> constructor = apiClass.getConstructor(new Class[0]);
            this.apiInstance = constructor.newInstance(new Object[0]);
            this.getBase64Method = apiClass.getMethod("getBase64", String.class);
        }

        @Override
        public CompletableFuture<@Nullable String> getHeadTexture(String name) {
            CompletableFuture<String> future = new CompletableFuture<String>();
            try {
                String value = (String)this.getBase64Method.invoke(this.apiInstance, name);
                if (value == null) {
                    Main.getPlugin().getLogger().warning("Head is not in head database: " + name);
                }
                future.complete(value);
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
            return future;
        }
    }

    private static interface HeadHandler {
        public CompletableFuture<@Nullable String> getHeadTexture(String var1);
    }
}

