/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx;

import java.util.logging.Logger;
import nl.rslot.ssx.Main;
import nl.rslot.ssx.conditional.ConditionalItem;
import nl.rslot.ssx.lib.derkutils.Cooldown;
import nl.rslot.ssx.lib.nbtapi.NBT;
import nl.rslot.ssx.lib.nbtapi.iface.ReadableNBT;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class ItemClickListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void onInteract(PlayerInteractEvent event) {
        Player player;
        Logger logger = Main.getPlugin().getLogger();
        if (Main.ITEM_DEBUG) {
            logger.info("[Click debug] Player " + event.getPlayer().getName() + " performed action " + String.valueOf(event.getAction()) + " on item using " + String.valueOf(event.getHand()));
        }
        if (event.getAction() == Action.PHYSICAL) {
            if (Main.ITEM_DEBUG) {
                logger.info("[Click debug] Event was ignored because it was not a click event");
            }
            return;
        }
        FileConfiguration inventory = Main.getConfigurationManager().getInventoryConfiguration();
        if (event.isCancelled() && inventory.getBoolean("ignore-cancelled", false)) {
            if (Main.ITEM_DEBUG) {
                logger.info("[Click debug] Event was ignored because it was cancelled and ignore-cancelled is enabled");
            }
            return;
        }
        ItemStack item = event.getItem();
        if (item == null || item.getType() == Material.AIR) {
            if (Main.ITEM_DEBUG) {
                logger.info("[Click debug] Event was ignored because the item was AIR");
            }
            return;
        }
        ReadableNBT nbt = NBT.readNbt(item);
        if (!nbt.hasTag("SSXActions")) {
            if (Main.ITEM_DEBUG) {
                logger.info("[Click debug] Event was ignored because the clicked item is not an SSX item");
            }
            return;
        }
        boolean cancel = inventory.getBoolean("cancel-click-event", false);
        if (cancel) {
            if (Main.ITEM_DEBUG) {
                logger.info("[Click debug] The event has been cancelled, because cancel-click-event is enabled");
            }
            event.setCancelled(true);
        }
        if ((player = event.getPlayer()).getOpenInventory().getType() != InventoryType.CRAFTING && player.getOpenInventory().getType() != InventoryType.CREATIVE) {
            if (Main.ITEM_DEBUG) {
                logger.info("[Click debug] Event was ignored because the player had an open inventory: " + String.valueOf(player.getOpenInventory().getType()));
            }
            return;
        }
        String globalCooldownId = player.getName() + "ssxitemglobal";
        if (Cooldown.getCooldown(globalCooldownId) > 0L) {
            if (Main.ITEM_DEBUG) {
                logger.info("[Click debug] Event was ignored because the global cooldown was in effect (this cooldown cannot be disabled)");
            }
            return;
        }
        Cooldown.addCooldown(globalCooldownId, 100L);
        ConditionalItem.runActions(event);
        if (Main.ITEM_DEBUG) {
            logger.info("[Click debug] Event handling completed, actions have been run.");
        }
    }
}

