/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx;

import java.util.List;
import java.util.Objects;
import nl.rslot.ssx.Main;
import nl.rslot.ssx.ServerSelectorX;
import nl.rslot.ssx.actions.Action;
import nl.rslot.ssx.conditional.ConditionalItem;
import nl.rslot.ssx.lib.derkutils.Cooldown;
import nl.rslot.ssx.lib.derkutils.bukkit.Colors;
import nl.rslot.ssx.lib.derkutils.bukkit.PlaceholderUtil;
import nl.rslot.ssx.lib.derkutils.bukkit.menu.IconMenu;
import nl.rslot.ssx.lib.derkutils.bukkit.menu.MenuCloseEvent;
import nl.rslot.ssx.lib.derkutils.bukkit.menu.OptionClickEvent;
import nl.rslot.ssx.lib.derkutils.bukkit.menu.SlotClickEvent;
import nl.rslot.ssx.lib.jetbrains-annotations.Nullable;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Menu
extends IconMenu {
    private final FileConfiguration config;
    private final String configName;
    private boolean closed = false;

    private static String getTitle(FileConfiguration config, Player player) {
        if (config == null || !config.isString("title")) {
            return "[title missing]";
        }
        String titleString = config.getBoolean("title-minimessage") ? Main.miniMessageToLegacy(config.getString("title")) : Colors.parseColors(config.getString("title"));
        titleString = titleString.replace("{player}", player.getName());
        titleString = PlaceholderUtil.parsePapiPlaceholders(player, titleString);
        return titleString;
    }

    public Menu(final Player player, final @Nullable FileConfiguration config, String configName) {
        super((Plugin)Main.getPlugin(), Menu.getTitle(config, player), config == null ? 1 : config.getInt("rows", 6), player);
        this.config = config;
        this.configName = configName;
        if (this.config == null || this.config.getConfigurationSection("menu") == null) {
            player.sendMessage("The configuration file failed to load, probably due to a syntax error.");
            player.sendMessage("Take a look at the console for any YAML errors, or paste your config in http://www.yamllint.com/");
            player.sendMessage("Check for identation and balanced quotes. If you want to use quotation marks in strings, they must be escaped properly by putting two quotation marks (for example \"\" or '').");
            player.sendMessage("Menu name: " + configName);
            return;
        }
        try {
            if (config.contains("sound")) {
                player.playSound(player.getLocation(), Sound.valueOf((String)config.getString("sound")), 1.0f, 1.0f);
            }
        }
        catch (IllegalArgumentException e) {
            Main.getPlugin().getLogger().warning("Invalid sound name in config file '" + configName + "'");
            Main.getPlugin().getLogger().warning("https://github.com/ServerSelectorX/ServerSelectorX/wiki/Sound-names");
        }
        int updateInterval = config.getInt("update-interval", 100);
        new BukkitRunnable(){

            public void run() {
                if (Menu.this.closed || Bukkit.getPlayer((String)player.getName()) == null) {
                    this.cancel();
                    return;
                }
                Menu.this.addItems();
                if (config.getBoolean("disable-updates", false)) {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)Main.getPlugin(), 0L, (long)updateInterval);
    }

    private void addItems() {
        OfflinePlayer potentiallyOffline = this.getPlayer();
        if (!(potentiallyOffline instanceof Player)) {
            Main.getPlugin().getLogger().warning("Player " + String.valueOf(potentiallyOffline.getUniqueId()) + " went offline?");
            return;
        }
        Player player = (Player)potentiallyOffline;
        ConfigurationSection menuSection = this.config.getConfigurationSection("menu");
        if (menuSection == null) {
            Main.getPlugin().getLogger().warning("Menu " + this.configName + " is missing a menu section. The menu will not contain any items.");
            return;
        }
        for (String key : menuSection.getKeys(false)) {
            if (!this.config.isConfigurationSection("menu." + key)) {
                player.sendMessage("Invalid item " + key + ", check indentation.");
                continue;
            }
            ConfigurationSection section = Objects.requireNonNull(menuSection.getConfigurationSection(key), "Null configuration section: menu." + key);
            String cooldownId = player.getName() + this.configName + key;
            try {
                ConditionalItem.getItem(player, section, cooldownId, item -> this.addToMenu(menuSection, key, player, (ItemStack)item));
            }
            catch (InvalidConfigurationException e) {
                player.sendMessage("Invalid configuration: " + e.getMessage());
            }
        }
    }

    public void addToMenu(ConfigurationSection menuSection, String key, Player player, ItemStack item) {
        if (key.equals("fill") || key.equals("-1")) {
            List skip = menuSection.getConfigurationSection(key).getIntegerList("fill-skip");
            for (int i = 0; i < this.getInventory().getSize(); ++i) {
                if (this.hasItem(i) || skip.contains(i)) continue;
                this.addItem(i, item);
            }
        } else {
            for (String split : key.split(",")) {
                int slot;
                try {
                    slot = Integer.parseInt(split);
                }
                catch (NumberFormatException e) {
                    player.sendMessage("Invalid slot number " + split);
                    return;
                }
                if (slot >= this.getInventory().getSize() || slot < 0) {
                    player.sendMessage("You put an item in slot " + slot + ", which is higher than the maximum number of slots in your menu.");
                    player.sendMessage("Use numbers 0 to " + (this.getInventory().getSize() - 1) + "or increase the number of rows in the config");
                    return;
                }
                this.addItem(slot, item);
            }
        }
    }

    @Override
    public boolean onOptionClick(OptionClickEvent event) {
        return ConditionalItem.runActions(event);
    }

    @Override
    public boolean onBlankClick(SlotClickEvent event) {
        if (!this.config.contains("empty-slot-actions")) {
            return false;
        }
        ConfigurationSection section = this.config.getConfigurationSection("empty-slot-actions");
        String matchedKey = null;
        block0: for (String key : section.getKeys(false)) {
            if (key.equals("other")) continue;
            for (String split : key.split(",")) {
                int slot = Integer.parseInt(split);
                if (event.getPosition() != slot) continue;
                matchedKey = key;
                continue block0;
            }
        }
        if (matchedKey == null && section.contains("other")) {
            matchedKey = "other";
        }
        if (matchedKey == null) {
            return false;
        }
        List actions = section.getStringList(matchedKey);
        return Action.runActions(event.getPlayer(), actions);
    }

    @Override
    public void onClose(MenuCloseEvent event) {
        String reason;
        this.closed = true;
        if (event.getOfflinePlayer() instanceof Player) {
            ServerSelectorX.getHotbarItemManager().updateSsxItems((Player)event.getOfflinePlayer());
        }
        if (this.config == null) {
            Main.getPlugin().getLogger().warning("Ignoring menu close event, config failed to load");
            return;
        }
        Cooldown.addCooldown("ssxitemglobal" + this.getPlayer().getName(), 100L);
        if (!this.config.contains("on-close")) {
            return;
        }
        switch (event.getReason()) {
            case PLAYER_CLOSED: {
                reason = "player";
                break;
            }
            case ITEM_CLICK: {
                reason = "item";
                break;
            }
            case PLAYER_QUIT: {
                reason = "quit";
                break;
            }
            default: {
                reason = null;
            }
        }
        if (reason == null) {
            return;
        }
        this.config.getMapList("on-close").forEach(map -> {
            List reasons = (List)map.get("reasons");
            if (reasons.contains(reason)) {
                List actions = (List)map.get("actions");
                if (event.getOfflinePlayer() instanceof Player) {
                    Action.runActions(event.getPlayer(), actions);
                } else {
                    Action.runActions(null, actions);
                }
            }
        });
    }
}

