/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.conditional.condition;

import java.util.HashMap;
import java.util.Map;
import nl.rslot.ssx.conditional.condition.Condition;
import nl.rslot.ssx.conditional.condition.CurrentServerCondition;
import nl.rslot.ssx.conditional.condition.EffectCondition;
import nl.rslot.ssx.conditional.condition.HasHiddenOthersCondition;
import nl.rslot.ssx.conditional.condition.InWorldCondition;
import nl.rslot.ssx.conditional.condition.OpenMenuCondition;
import nl.rslot.ssx.conditional.condition.PapiCondition;
import nl.rslot.ssx.conditional.condition.PermissionCondition;
import nl.rslot.ssx.conditional.condition.ServerOnlineCondition;
import nl.rslot.ssx.conditional.condition.ServerPlaceholderCondition;
import nl.rslot.ssx.lib.jetbrains-annotations.NotNull;
import nl.rslot.ssx.lib.jetbrains-annotations.Nullable;

public class Conditions {
    private static final Map<String, Condition> CONDITIONS_BY_TYPE;

    @Nullable
    public static Condition getConditionByType(@NotNull String type) {
        return CONDITIONS_BY_TYPE.get(type);
    }

    static {
        Condition[] conditions = new Condition[]{new CurrentServerCondition(), new EffectCondition(), new HasHiddenOthersCondition(), new InWorldCondition(), new OpenMenuCondition(), new PapiCondition(), new PermissionCondition(), new ServerPlaceholderCondition(), new ServerOnlineCondition()};
        CONDITIONS_BY_TYPE = new HashMap<String, Condition>(conditions.length);
        for (Condition condition : conditions) {
            CONDITIONS_BY_TYPE.put(condition.getType(), condition);
        }
    }
}

