/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.conditional.condition;

import java.util.Map;
import nl.rslot.ssx.Main;
import nl.rslot.ssx.conditional.condition.Condition;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class EffectCondition
extends Condition {
    EffectCondition() {
        super("has-effect");
    }

    @Override
    public boolean isTrue(Player player, Map<String, Object> options) throws InvalidConfigurationException {
        if (!options.containsKey("effect-type")) {
            throw new InvalidConfigurationException("Missing required option for conditional: 'effect-type'");
        }
        String effectTypeStr = (String)options.get("effect-type");
        PotionEffectType effectType = PotionEffectType.getByName((String)effectTypeStr);
        if (effectType == null) {
            Main.getPlugin().getLogger().warning(String.format("Skipped effect condition for %s, effect type %s is invalid", player.getName(), effectTypeStr));
            return false;
        }
        PotionEffect activeEffect = player.getPotionEffect(effectType);
        if (activeEffect == null) {
            return false;
        }
        if (!options.containsKey("effect-minimum-strength")) {
            return true;
        }
        int minimumStrength = (Integer)options.get("effect-minimum-strength");
        return activeEffect.getAmplifier() + 1 >= minimumStrength;
    }
}

