/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.lib.derkutils.bukkit;

import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import nl.rslot.ssx.lib.checkerframework.checker.formatter.qual.UnknownFormat;
import nl.rslot.ssx.lib.checkerframework.checker.initialization.qual.Initialized;
import nl.rslot.ssx.lib.checkerframework.checker.nullness.qual.NonNull;
import nl.rslot.ssx.lib.checkerframework.checker.nullness.qual.Nullable;
import nl.rslot.ssx.lib.checkerframework.checker.nullness.qual.UnknownKeyFor;
import nl.rslot.ssx.lib.checkerframework.checker.optional.qual.MaybePresent;
import nl.rslot.ssx.lib.checkerframework.checker.regex.qual.UnknownRegex;
import nl.rslot.ssx.lib.checkerframework.common.aliasing.qual.MaybeAliased;
import nl.rslot.ssx.lib.checkerframework.common.aliasing.qual.MaybeLeaked;
import nl.rslot.ssx.lib.derkutils.bukkit.Colors;
import nl.rslot.ssx.lib.derkutils.bukkit.PlaceholderUtil;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;

public abstract class AbstractItemBuilder<@UnknownKeyFor T extends @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat AbstractItemBuilder<T>> {
    protected @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat ItemStack item;

    public AbstractItemBuilder(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Material material) {
        this.item = new ItemStack(Objects.requireNonNull(material, "Material is null"));
    }

    public AbstractItemBuilder(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat ItemStack item) {
        this.item = Objects.requireNonNull(item, "item is null");
    }

    public abstract T getInstance();

    public <M extends ItemMeta> @NonNull T editMeta(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Class<M> metaClasss, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Consumer<M> metaEditor) {
        @Nullable ItemMeta meta = this.item.getItemMeta();
        metaEditor.accept(meta);
        this.item.setItemMeta(meta);
        return this.getInstance();
    }

    public @NonNull T amount(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat int amount) {
        this.item.setAmount(amount);
        return this.getInstance();
    }

    public @NonNull T name(@Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String name) {
        ItemMeta meta = this.item.getItemMeta();
        meta.setDisplayName(name);
        this.item.setItemMeta(meta);
        return this.getInstance();
    }

    public @NonNull T coloredName(@Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String name) {
        ItemMeta meta = this.item.getItemMeta();
        if (name == null) {
            meta.setDisplayName(null);
        } else {
            meta.setDisplayName(Colors.parseColors(name));
        }
        this.item.setItemMeta(meta);
        return this.getInstance();
    }

    public @NonNull T lore(String ... lore) {
        ItemMeta meta = this.item.getItemMeta();
        if (lore == null) {
            meta.setLore(null);
        } else {
            meta.setLore(Arrays.asList(lore));
        }
        this.item.setItemMeta(meta);
        return this.getInstance();
    }

    public @NonNull T coloredLore(String ... lore) {
        ItemMeta meta = this.item.getItemMeta();
        if (lore == null) {
            meta.setLore(null);
        } else {
            meta.setLore(Colors.parseColors(Arrays.asList(lore)));
        }
        this.item.setItemMeta(meta);
        return this.getInstance();
    }

    public @NonNull T lore(@Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> lore) {
        ItemMeta meta = this.item.getItemMeta();
        meta.setLore(lore);
        this.item.setItemMeta(meta);
        return this.getInstance();
    }

    public @NonNull T coloredLore(@Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> lore) {
        ItemMeta meta = this.item.getItemMeta();
        if (lore == null) {
            meta.setLore(null);
        } else {
            meta.setLore(Colors.parseColors(lore));
        }
        this.item.setItemMeta(meta);
        return this.getInstance();
    }

    public @NonNull T skullOwner(@Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat OfflinePlayer player) {
        SkullMeta meta = (SkullMeta)this.item.getItemMeta();
        meta.setOwningPlayer(player);
        this.item.setItemMeta((ItemMeta)meta);
        return this.getInstance();
    }

    public @NonNull T leatherArmorColor(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Color color) {
        Objects.requireNonNull(color, "Color is null");
        LeatherArmorMeta meta = (LeatherArmorMeta)this.item.getItemMeta();
        meta.setColor(color);
        this.item.setItemMeta((ItemMeta)meta);
        return this.getInstance();
    }

    public @NonNull T enchant(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Enchantment type) {
        return this.enchant(type, 1);
    }

    public @NonNull T enchant(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Enchantment type, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat int level) {
        Objects.requireNonNull(type, "Enchantment type is null");
        this.item.addEnchantment(type, level);
        return this.getInstance();
    }

    public @NonNull T unsafeEnchant(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Enchantment type, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat int level) {
        Objects.requireNonNull(type, "Enchantment type is null");
        this.item.addUnsafeEnchantment(type, level);
        return this.getInstance();
    }

    public @NonNull T material(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Material material) {
        this.item.setType(material == null ? Material.AIR : material);
        return this.getInstance();
    }

    public @NonNull T type(@Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Material type) {
        this.item.setType(type == null ? Material.AIR : type);
        return this.getInstance();
    }

    public @NonNull T unbreakable() {
        ItemMeta meta = this.item.getItemMeta();
        meta.setUnbreakable(true);
        this.item.setItemMeta(meta);
        return this.getInstance();
    }

    public @NonNull T damage(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat int damage) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta != null) {
            ((Damageable)meta).setDamage(damage);
            this.item.setItemMeta(meta);
        }
        return this.getInstance();
    }

    public @NonNull T namePlaceholder(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String key, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String value) {
        Objects.requireNonNull(key, "Placeholder key is null");
        Objects.requireNonNull(value, "Placeholder value is null");
        if (this.item.getItemMeta() == null) {
            return this.getInstance();
        }
        return this.name(this.item.getItemMeta().getDisplayName().replace(key, value));
    }

    public @NonNull T namePlaceholders(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Map<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> placeholders) {
        Objects.requireNonNull(placeholders, "Placeholder map is null");
        if (this.item.getItemMeta() == null) {
            return this.getInstance();
        }
        placeholders.forEach(this::namePlaceholder);
        return this.getInstance();
    }

    public @NonNull T namePlaceholderOptional(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String key, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Supplier<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> value) {
        Objects.requireNonNull(key, "Placeholder key is null");
        Objects.requireNonNull(value, "Placeholder value is null");
        if (this.item.getItemMeta() == null) {
            return this.getInstance();
        }
        String oldName = this.item.getItemMeta().getDisplayName();
        if (oldName.contains(key)) {
            return this.name(oldName.replace(key, value.get()));
        }
        return this.getInstance();
    }

    public @NonNull T namePlaceholdersOptional(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Map<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Supplier<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String>> placeholders) {
        Objects.requireNonNull(placeholders, "Placeholder map is null");
        if (this.item.getItemMeta() == null) {
            return this.getInstance();
        }
        placeholders.forEach(this::namePlaceholderOptional);
        return this.getInstance();
    }

    public @NonNull T lorePlaceholder(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String key, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String value) {
        Objects.requireNonNull(key, "Placeholder key is null");
        Objects.requireNonNull(value, "Placeholder value is null");
        if (this.item.getItemMeta() == null || this.item.getItemMeta().getLore() == null) {
            return this.getInstance();
        }
        return this.lore(this.item.getItemMeta().getLore().stream().map(s -> s.replace(key, value)).collect(Collectors.toList()));
    }

    public @NonNull T lorePlaceholders(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Map<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> placeholders) {
        Objects.requireNonNull(placeholders, "Placeholder map is null");
        if (this.item.getItemMeta() == null || this.item.getItemMeta().getLore() == null) {
            return this.getInstance();
        }
        placeholders.forEach(this::lorePlaceholder);
        return this.getInstance();
    }

    public @NonNull T lorePlaceholderOptional(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String key, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Supplier<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> value) {
        Objects.requireNonNull(key, "Placeholder key is null");
        Objects.requireNonNull(value, "Placeholder value is null");
        if (this.item.getItemMeta() == null || this.item.getItemMeta().getLore() == null) {
            return this.getInstance();
        }
        return this.lore(this.item.getItemMeta().getLore().stream().map(s -> {
            if (s.contains(key)) {
                return s.replace(key, (CharSequence)value.get());
            }
            return s;
        }).collect(Collectors.toList()));
    }

    public @NonNull T lorePlaceholdersOptional(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Map<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Supplier<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String>> placeholders) {
        Objects.requireNonNull(placeholders, "Placeholder map is null");
        if (this.item.getItemMeta() == null || this.item.getItemMeta().getLore() == null) {
            return this.getInstance();
        }
        placeholders.forEach(this::lorePlaceholderOptional);
        return this.getInstance();
    }

    public @NonNull T skullTexture(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String skinTextureJsonBase64) {
        URL skinTextureUrl;
        String skinTextureJson;
        try {
            skinTextureJson = new String(Base64.getDecoder().decode(skinTextureJsonBase64), StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to decode skin texture base64: " + skinTextureJsonBase64);
        }
        try {
            skinTextureUrl = new URI(JsonParser.parseString((String)skinTextureJson).getAsJsonObject().get("textures").getAsJsonObject().get("SKIN").getAsJsonObject().get("url").getAsString()).toURL();
        }
        catch (JsonSyntaxException | IllegalStateException | MalformedURLException | URISyntaxException e) {
            throw new RuntimeException("Failed to parse skin texture json: " + skinTextureJson);
        }
        return this.skullTextureURL(skinTextureUrl);
    }

    public T skullTextureURL(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat URL skinTextureUrl) {
        try {
            Class<?> iPlayerProfile = Class.forName("org.bukkit.profile.PlayerProfile");
            Class<?> iPlayerTextures = Class.forName("org.bukkit.profile.PlayerTextures");
            Method createPlayerProfile = Bukkit.getServer().getClass().getMethod("createPlayerProfile", UUID.class);
            Object playerProfile = createPlayerProfile.invoke((Object)Bukkit.getServer(), UUID.randomUUID());
            Object playerTextures = iPlayerProfile.getMethod("getTextures", new Class[0]).invoke(playerProfile, new Object[0]);
            iPlayerTextures.getMethod("setSkin", URL.class).invoke(playerTextures, skinTextureUrl);
            iPlayerProfile.getMethod("setTextures", iPlayerTextures).invoke(playerProfile, playerTextures);
            SkullMeta meta = (SkullMeta)this.item.getItemMeta();
            SkullMeta.class.getMethod("setOwnerProfile", iPlayerProfile).invoke((Object)meta, playerProfile);
            this.item.setItemMeta((ItemMeta)meta);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new UnsupportedOperationException("Method not found, only available on 1.20+", e);
        }
        catch (IllegalAccessException | InvocationTargetException e2) {
            e2.printStackTrace();
        }
        return this.getInstance();
    }

    public T addHideFlags(ItemFlag ... itemFlags) {
        ItemMeta meta = this.item.getItemMeta();
        if (meta == null) {
            throw new IllegalStateException("Item meta is null");
        }
        meta.addAttributeModifier(Attribute.GENERIC_ATTACK_DAMAGE, new AttributeModifier(UUID.randomUUID(), "", 1.0, AttributeModifier.Operation.ADD_NUMBER));
        meta.addItemFlags(itemFlags);
        this.item.setItemMeta(meta);
        return this.getInstance();
    }

    public T removeHideFlags() {
        ItemMeta meta = this.item.getItemMeta();
        if (meta == null) {
            throw new IllegalStateException("Item meta is null");
        }
        meta.removeItemFlags(ItemFlag.values());
        this.item.setItemMeta(meta);
        return this.getInstance();
    }

    public @NonNull T hideFlags() {
        return this.addHideFlags(ItemFlag.values());
    }

    public @NonNull T hideFlags(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat boolean hideAllFlags) {
        if (hideAllFlags) {
            return this.hideFlags();
        }
        return this.removeHideFlags();
    }

    public T modelData(@Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Integer data) {
        ItemMeta meta = this.item.getItemMeta();
        try {
            Method setCustomModelData = ItemMeta.class.getMethod("setCustomModelData", Integer.class);
            setCustomModelData.invoke((Object)meta, data);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new UnsupportedOperationException("Cannot set custom model data in this Minecraft version", e);
        }
        this.item.setItemMeta(meta);
        return this.getInstance();
    }

    public @NonNull T placeholder(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String key, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String value) {
        Objects.requireNonNull(key, "Placeholder key is null");
        Objects.requireNonNull(value, "Placeholder value is null");
        return ((AbstractItemBuilder)this.namePlaceholder(key, value)).lorePlaceholder(key, value);
    }

    public @NonNull T placeholders(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Map<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> placeholders) {
        Objects.requireNonNull(placeholders, "Placeholder map is null");
        return ((AbstractItemBuilder)this.namePlaceholders(placeholders)).lorePlaceholders(placeholders);
    }

    public @NonNull T placeholderOptional(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String key, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Supplier<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> value) {
        Objects.requireNonNull(key, "Placeholder key is null");
        Objects.requireNonNull(value, "Placeholder value is null");
        return ((AbstractItemBuilder)this.namePlaceholderOptional(key, value)).lorePlaceholderOptional(key, value);
    }

    public @NonNull T placeholdersOptional(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Map<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Supplier<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String>> placeholders) {
        Objects.requireNonNull(placeholders, "Placeholder map is null");
        return ((AbstractItemBuilder)this.namePlaceholdersOptional(placeholders)).lorePlaceholdersOptional(placeholders);
    }

    public @NonNull T lorePapi(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Player player) {
        if (this.item.getItemMeta() == null || this.item.getItemMeta().getLore() == null) {
            return this.getInstance();
        }
        return this.lore(this.item.getItemMeta().getLore().stream().map(s -> PlaceholderUtil.parsePapiPlaceholders(player, s)).collect(Collectors.toList()));
    }

    public @NonNull T namePapi(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Player player) {
        if (this.item.getItemMeta() == null) {
            return this.getInstance();
        }
        return this.name(PlaceholderUtil.parsePapiPlaceholders(player, this.item.getItemMeta().getDisplayName()));
    }

    public @NonNull T papi(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Player player) {
        Objects.requireNonNull(player, "Player is null");
        this.namePapi(player);
        return this.lorePapi(player);
    }

    public @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat ItemStack create() {
        return this.item;
    }
}

