/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.lib.derkutils.bukkit;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import nl.rslot.ssx.lib.checkerframework.checker.formatter.qual.UnknownFormat;
import nl.rslot.ssx.lib.checkerframework.checker.initialization.qual.Initialized;
import nl.rslot.ssx.lib.checkerframework.checker.nullness.qual.NonNull;
import nl.rslot.ssx.lib.checkerframework.checker.nullness.qual.UnknownKeyFor;
import nl.rslot.ssx.lib.checkerframework.checker.optional.qual.MaybePresent;
import nl.rslot.ssx.lib.checkerframework.checker.regex.qual.UnknownRegex;
import nl.rslot.ssx.lib.checkerframework.common.aliasing.qual.MaybeAliased;
import nl.rslot.ssx.lib.checkerframework.common.aliasing.qual.MaybeLeaked;
import nl.rslot.ssx.lib.derkutils.bukkit.AbstractItemBuilder;
import nl.rslot.ssx.lib.nbtapi.NBT;
import nl.rslot.ssx.lib.nbtapi.iface.ReadWriteItemNBT;
import nl.rslot.ssx.lib.nbtapi.iface.ReadWriteNBT;
import nl.rslot.ssx.lib.nbtapi.iface.ReadableNBTList;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class NbtItemBuilder
extends AbstractItemBuilder<NbtItemBuilder> {
    public NbtItemBuilder(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Material material) {
        super(material);
    }

    public NbtItemBuilder(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat ItemStack item) {
        super(item);
    }

    @Override
    public @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat NbtItemBuilder getInstance() {
        return this;
    }

    @Deprecated
    public @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat NbtItemBuilder canDestroy(String ... vanillaNamespacedNames) {
        Objects.requireNonNull(vanillaNamespacedNames, "names varargs is null");
        NBT.modify(this.item, nbt -> nbt.getStringList("CanDestroy").addAll(List.of(vanillaNamespacedNames)));
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat NbtItemBuilder canDestroy(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Set<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Material> materials) {
        NBT.modify(this.item, nbt -> {
            ReadableNBTList list = nbt.getStringList("CanDestroy");
            for (Material material : materials) {
                list.add(material.getKey().toString());
            }
        });
        return this;
    }

    @Deprecated
    public @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat NbtItemBuilder canPlaceOn(String ... vanillaNamespacedNames) {
        Objects.requireNonNull(vanillaNamespacedNames, "names varargs is null");
        NBT.modify(this.item, nbt -> nbt.getStringList("CanPlaceOn").addAll(List.of(vanillaNamespacedNames)));
        return this;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat NbtItemBuilder canPlaceOn(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Set<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Material> materials) {
        NBT.modify(this.item, nbt -> {
            ReadableNBTList list = nbt.getStringList("CanPlaceOn");
            for (Material material : materials) {
                list.add(material.getKey().toString());
            }
        });
        return this;
    }

    @Override
    public @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat NbtItemBuilder skullTexture(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String texture) {
        Objects.requireNonNull(texture, "Texture string is null");
        try {
            super.skullTexture(texture);
            return this;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.editNbt(nbt -> {
                ReadWriteNBT skullOwner = nbt.getOrCreateCompound("SkullOwner");
                skullOwner.setString("Id", UUID.randomUUID().toString());
                skullOwner.getOrCreateCompound("Properties").getCompoundList("textures").addCompound().setString("Value", texture);
            });
            return this;
        }
    }

    @Deprecated
    public @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat NbtItemBuilder hideFlags(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat int hideFlags) {
        NBT.modify(this.item, nbt -> nbt.setInteger("HideFlags", hideFlags));
        return this;
    }

    public @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat NbtItemBuilder editNbt(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Consumer<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat ReadWriteItemNBT> nbtModifier) {
        NBT.modify(this.item, nbtModifier);
        return this;
    }
}

