/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.lib.derkutils.bukkit;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import nl.rslot.ssx.lib.checkerframework.checker.formatter.qual.UnknownFormat;
import nl.rslot.ssx.lib.checkerframework.checker.initialization.qual.Initialized;
import nl.rslot.ssx.lib.checkerframework.checker.nullness.qual.NonNull;
import nl.rslot.ssx.lib.checkerframework.checker.nullness.qual.UnknownKeyFor;
import nl.rslot.ssx.lib.checkerframework.checker.optional.qual.MaybePresent;
import nl.rslot.ssx.lib.checkerframework.checker.regex.qual.UnknownRegex;
import nl.rslot.ssx.lib.checkerframework.common.aliasing.qual.MaybeAliased;
import nl.rslot.ssx.lib.checkerframework.common.aliasing.qual.MaybeLeaked;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PlaceholderUtil {
    private static @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Method papiParseString = null;
    private static @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Method papiParseList = null;

    public static @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String parsePlaceholders(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String string, Placeholder ... placeholders) {
        Objects.requireNonNull(string, "input string must not be null");
        Objects.requireNonNull(placeholders, "placeholders varargs is null");
        for (Placeholder p : placeholders) {
            string = Objects.requireNonNull(p, "a placeholder is null").parse(string);
        }
        return string;
    }

    public static @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String parsePlaceholders(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String string, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Collection<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Placeholder> placeholders) {
        Objects.requireNonNull(string, "input string must not be null");
        Objects.requireNonNull(placeholders, "placeholders collection is null");
        for (Placeholder p : placeholders) {
            string = Objects.requireNonNull(p, "a placeholder is null").parse(string);
        }
        return string;
    }

    public static @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> parsePlaceholders(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> strings, Placeholder ... placeholders) {
        Objects.requireNonNull(strings, "strings list is null");
        Objects.requireNonNull(placeholders, "placeholders array is null");
        for (Placeholder p : placeholders) {
            strings = Objects.requireNonNull(p, "a placeholder is null").parse(strings);
        }
        return strings;
    }

    public static @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> parsePlaceholders(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> strings, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Collection<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Placeholder> placeholders) {
        Objects.requireNonNull(strings, "strings list is null");
        Objects.requireNonNull(placeholders, "placeholders collection is null");
        for (Placeholder p : placeholders) {
            strings = Objects.requireNonNull(p, "a placeholder is null").parse(strings);
        }
        return strings;
    }

    public static @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String parsePapiPlaceholders(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Player player, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String string, Placeholder ... placeholders) {
        Objects.requireNonNull(player, "Player must not be null");
        Objects.requireNonNull(string, "Input string must not be null");
        Objects.requireNonNull(placeholders, "Placeholders varargs is null");
        for (Placeholder p : placeholders) {
            string = Objects.requireNonNull(p, "a placeholder is null").parse(string);
        }
        string = PlaceholderUtil.parsePapiPlaceholders(player, string);
        return string;
    }

    public static @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String parsePapiPlaceholders(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Player player, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String string, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Collection<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Placeholder> placeholders) {
        Objects.requireNonNull(player, "Player must not be null");
        Objects.requireNonNull(string, "Input string must not be null");
        Objects.requireNonNull(placeholders, "Placeholders collection is null");
        for (Placeholder p : placeholders) {
            string = Objects.requireNonNull(p, "a placeholder is null").parse(string);
        }
        string = PlaceholderUtil.parsePapiPlaceholders(player, string);
        return string;
    }

    public static @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat List<@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> parsePapiPlaceholders(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Player player, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat List<@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> strings, Placeholder ... placeholders) {
        Objects.requireNonNull(player, "Player must not be null");
        Objects.requireNonNull(placeholders, "Placeholders array is null");
        for (Placeholder p : placeholders) {
            strings = Objects.requireNonNull(p, "A placeholder is null").parse(strings);
        }
        strings = PlaceholderUtil.parsePapiPlaceholders(player, strings);
        return strings;
    }

    public static @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat List<@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> parsePapiPlaceholders(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Player player, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat List<@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> strings, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Collection<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Placeholder> placeholders) {
        Objects.requireNonNull(player, "Player must not be null");
        Objects.requireNonNull(placeholders, "Placeholders collection is null");
        for (Placeholder p : placeholders) {
            strings = Objects.requireNonNull(p, "A placeholder is null").parse(strings);
        }
        strings = PlaceholderUtil.parsePapiPlaceholders(player, strings);
        return strings;
    }

    public static @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String parsePapiPlaceholders(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Player player, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String string) {
        Objects.requireNonNull(player, "Player must not be null");
        Objects.requireNonNull(string, "Provided string must not be null");
        if (papiParseString == null) {
            return string;
        }
        try {
            return (String)papiParseString.invoke(null, player, string);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return string;
        }
    }

    public static @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> parsePapiPlaceholders(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Player player, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> strings) {
        Objects.requireNonNull(player, "Player must not be null");
        Objects.requireNonNull(strings, "Provided string list must not be null");
        if (papiParseList == null) {
            return strings;
        }
        try {
            return (List)papiParseList.invoke(null, player, strings);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return strings;
        }
    }

    static {
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            try {
                Class<?> c = Class.forName("me.clip.placeholderapi.PlaceholderAPI");
                papiParseString = c.getMethod("setPlaceholders", Player.class, String.class);
                papiParseList = c.getMethod("setPlaceholders", Player.class, List.class);
            }
            catch (ClassNotFoundException | IllegalArgumentException | NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
            }
        }
    }

    public static class Placeholder {
        private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String key;
        private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String value;

        public Placeholder(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String key, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String value) {
            this.key = Objects.requireNonNull(key, "Placeholder key is null");
            this.value = Objects.requireNonNull(value, "Placeholder value is null");
        }

        public @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String parse(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String string) {
            return string.replace(this.key, this.value);
        }

        public @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> parse(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat List<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String> list) {
            return list.stream().map(this::parse).collect(Collectors.toList());
        }
    }
}

