/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.lib.derkutils.bukkit.menu;

import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import nl.rslot.ssx.lib.checkerframework.checker.formatter.qual.UnknownFormat;
import nl.rslot.ssx.lib.checkerframework.checker.initialization.qual.Initialized;
import nl.rslot.ssx.lib.checkerframework.checker.nullness.qual.NonNull;
import nl.rslot.ssx.lib.checkerframework.checker.nullness.qual.Nullable;
import nl.rslot.ssx.lib.checkerframework.checker.nullness.qual.UnknownKeyFor;
import nl.rslot.ssx.lib.checkerframework.checker.optional.qual.MaybePresent;
import nl.rslot.ssx.lib.checkerframework.checker.regex.qual.UnknownRegex;
import nl.rslot.ssx.lib.checkerframework.common.aliasing.qual.MaybeAliased;
import nl.rslot.ssx.lib.checkerframework.common.aliasing.qual.MaybeLeaked;
import nl.rslot.ssx.lib.derkutils.bukkit.menu.CloseReason;
import nl.rslot.ssx.lib.derkutils.bukkit.menu.MenuCloseEvent;
import nl.rslot.ssx.lib.derkutils.bukkit.menu.OptionClickEvent;
import nl.rslot.ssx.lib.derkutils.bukkit.menu.SlotClickEvent;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public abstract class IconMenu
implements Listener {
    private @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String name;
    private final @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat int size;
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat UUID uuid;
    private final @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Inventory inventory;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat InventoryView view;
    private @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat boolean closeEventCalled = false;
    private @Nullable @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat CloseReason closeReason = null;

    public IconMenu(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Plugin plugin, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String name, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat int rows, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Player player) {
        this(name, rows, player, t -> t.runTaskTimer(plugin, 1L, 1L), l -> Bukkit.getServer().getPluginManager().registerEvents(l, plugin));
    }

    public IconMenu(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String name, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat int rows, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Player player, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Consumer<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat BukkitRunnable> timerRegistrar, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Consumer<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Listener> listenerRegistrar) {
        Objects.requireNonNull(name, "Name is null");
        Objects.requireNonNull(player, "Player is null");
        Objects.requireNonNull(listenerRegistrar, "Timer registrar is null");
        Objects.requireNonNull(listenerRegistrar, "Listener registrar is null");
        this.size = rows * 9;
        this.name = name;
        this.uuid = player.getUniqueId();
        this.inventory = Bukkit.createInventory((InventoryHolder)player, (int)this.size, (String)this.name);
        InventoryView view = player.openInventory(this.inventory);
        if (view == null) {
            System.err.println("IconMenu: Failed to open inventory for " + player.getName() + ". Did a plugin cancel the event?");
            return;
        }
        this.view = view;
        listenerRegistrar.accept(this);
        timerRegistrar.accept(new BukkitRunnable(){

            public void run() {
                Player player = Bukkit.getPlayer((UUID)IconMenu.this.uuid);
                if (player == null) {
                    if (!IconMenu.this.closeEventCalled) {
                        IconMenu.this.closeEventCalled = true;
                        IconMenu.this.onClose(new MenuCloseEvent(Bukkit.getOfflinePlayer((UUID)IconMenu.this.uuid), CloseReason.PLAYER_QUIT));
                    }
                } else if (!player.getOpenInventory().getTopInventory().equals(IconMenu.this.inventory)) {
                    if (!IconMenu.this.closeEventCalled) {
                        IconMenu.this.closeEventCalled = true;
                        if (IconMenu.this.closeReason == null) {
                            IconMenu.this.closeReason = CloseReason.PLAYER_CLOSED;
                        }
                        IconMenu.this.onClose(new MenuCloseEvent((OfflinePlayer)player, IconMenu.this.closeReason));
                    }
                } else {
                    return;
                }
                HandlerList.unregisterAll((Listener)IconMenu.this);
                this.cancel();
            }
        });
    }

    public abstract @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat boolean onOptionClick(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat OptionClickEvent var1);

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat boolean onBlankClick(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat SlotClickEvent event) {
        return false;
    }

    public void onClose(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat MenuCloseEvent event) {
    }

    public void setName(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String name) {
        this.name = name;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat int getSize() {
        return this.size;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat OfflinePlayer getPlayer() {
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        return player != null ? player : Bukkit.getOfflinePlayer((UUID)this.uuid);
    }

    public void close() {
        this.closeReason = CloseReason.FORCE_CLOSE;
        this.view.close();
    }

    public void addItem(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat int slot, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat ItemStack item) {
        this.inventory.setItem(slot, item);
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat boolean hasItem(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat int slot) {
        ItemStack item = this.inventory.getItem(slot);
        return item != null && item.getType() != Material.AIR;
    }

    public void clear() {
        this.inventory.clear();
    }

    public @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Inventory getInventory() {
        return this.inventory;
    }

    public @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat InventoryView getInventoryView() {
        return this.view;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat InventoryClickEvent event) {
        boolean close;
        if (!event.getView().getTopInventory().equals(this.inventory)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        Player clicker = (Player)event.getWhoClicked();
        if (slot >= 0 && slot < this.size && (close = this.hasItem(slot) ? this.onOptionClick(new OptionClickEvent(clicker, slot, event.getClick(), this.inventory.getItem(slot))) : this.onBlankClick(new SlotClickEvent(clicker, slot, event.getClick())))) {
            this.closeReason = CloseReason.ITEM_CLICK;
            this.view.close();
        }
    }
}

