/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.lib.derkutils.bukkit.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import nl.rslot.ssx.lib.checkerframework.checker.formatter.qual.FormatBottom;
import nl.rslot.ssx.lib.checkerframework.checker.formatter.qual.UnknownFormat;
import nl.rslot.ssx.lib.checkerframework.checker.initialization.qual.Initialized;
import nl.rslot.ssx.lib.checkerframework.checker.nullness.qual.NonNull;
import nl.rslot.ssx.lib.checkerframework.checker.nullness.qual.Nullable;
import nl.rslot.ssx.lib.checkerframework.checker.nullness.qual.UnknownKeyFor;
import nl.rslot.ssx.lib.checkerframework.checker.optional.qual.MaybePresent;
import nl.rslot.ssx.lib.checkerframework.checker.optional.qual.Present;
import nl.rslot.ssx.lib.checkerframework.checker.regex.qual.RegexBottom;
import nl.rslot.ssx.lib.checkerframework.checker.regex.qual.UnknownRegex;
import nl.rslot.ssx.lib.checkerframework.common.aliasing.qual.MaybeAliased;
import nl.rslot.ssx.lib.checkerframework.common.aliasing.qual.MaybeLeaked;
import nl.rslot.ssx.lib.checkerframework.common.aliasing.qual.NonLeaked;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.entity.Player;

public class ReflectionUtil {
    private static final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Map<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present @UnknownRegex @RegexBottom @UnknownFormat @FormatBottom ?>> classCache = new HashMap();
    private static @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Method playerPingMethod;

    private static /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonLeaked @MaybeAliased @MaybeLeaked @MaybeAliased @MaybePresent @Present @UnknownRegex @RegexBottom @UnknownFormat @FormatBottom ?> getCB(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String pathAfterCB) {
        classCache.computeIfAbsent("CB" + pathAfterCB, key -> {
            try {
                return Class.forName(Bukkit.getServer().getClass().getPackage().getName() + "." + pathAfterCB);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
        return classCache.get("CB" + pathAfterCB);
    }

    public static @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat int getPing(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Player player) {
        if (playerPingMethod != null) {
            try {
                return (Integer)playerPingMethod.invoke((Object)player, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
                return 0;
            }
        }
        try {
            String version = Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3];
            Class<?> entityPlayerClass = Class.forName("net.minecraft.server." + version + ".EntityPlayer");
            Object entityPlayer = ReflectionUtil.getCB(".entity.CraftPlayer").getMethod("getHandle", new Class[0]).invoke((Object)player, new Object[0]);
            Object ping = entityPlayerClass.getField("ping").get(entityPlayer);
            return (Integer)ping;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e2) {
            e2.printStackTrace();
            return 0;
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat CommandMap getCommandMap() {
        try {
            Field field = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            field.setAccessible(true);
            return (CommandMap)field.get(Bukkit.getServer());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerCommand(@NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String name, @NonNull @UnknownKeyFor @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Command command) {
        ReflectionUtil.getCommandMap().register(name, command);
    }

    public static @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Map<@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat String, @UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Command> getKnownCommands() {
        try {
            CommandMap map = ReflectionUtil.getCommandMap();
            return (Map)map.getClass().getMethod("getKnownCommands", new Class[0]).invoke((Object)map, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void unregisterCommand(@UnknownKeyFor @NonNull @Initialized @MaybeLeaked @MaybeAliased @MaybePresent @UnknownRegex @UnknownFormat Command command) {
        ArrayList<String> names = new ArrayList<String>();
        names.add(command.getName());
        names.addAll(command.getAliases());
        command.unregister(ReflectionUtil.getCommandMap());
        names.forEach(ReflectionUtil.getKnownCommands()::remove);
    }

    static {
        try {
            playerPingMethod = Player.class.getMethod("ping", new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            playerPingMethod = null;
        }
    }
}

