/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.lib.kyori.adventure.identity;

import java.util.Locale;
import java.util.UUID;
import java.util.stream.Stream;
import nl.rslot.ssx.lib.jetbrains-annotations.ApiStatus;
import nl.rslot.ssx.lib.jetbrains-annotations.NotNull;
import nl.rslot.ssx.lib.kyori.adventure.identity.Identified;
import nl.rslot.ssx.lib.kyori.adventure.identity.IdentityImpl;
import nl.rslot.ssx.lib.kyori.adventure.identity.NilIdentity;
import nl.rslot.ssx.lib.kyori.adventure.key.Key;
import nl.rslot.ssx.lib.kyori.adventure.pointer.Pointer;
import nl.rslot.ssx.lib.kyori.adventure.text.Component;
import nl.rslot.ssx.lib.kyori.examination.Examinable;
import nl.rslot.ssx.lib.kyori.examination.ExaminableProperty;

@ApiStatus.NonExtendable
public interface Identity
extends Examinable,
Identified {
    public static final Pointer<String> NAME = Pointer.pointer(String.class, Key.key("adventure", "name"));
    public static final Pointer<UUID> UUID = Pointer.pointer(UUID.class, Key.key("adventure", "uuid"));
    public static final Pointer<Component> DISPLAY_NAME = Pointer.pointer(Component.class, Key.key("adventure", "display_name"));
    public static final Pointer<Locale> LOCALE = Pointer.pointer(Locale.class, Key.key("adventure", "locale"));

    @NotNull
    public static Identity nil() {
        return NilIdentity.INSTANCE;
    }

    @NotNull
    public static Identity identity(@NotNull UUID uuid) {
        if (uuid.equals(NilIdentity.NIL_UUID)) {
            return NilIdentity.INSTANCE;
        }
        return new IdentityImpl(uuid);
    }

    @NotNull
    public UUID uuid();

    @Override
    @NotNull
    default public Identity identity() {
        return this;
    }

    @Override
    @NotNull
    default public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("uuid", this.uuid()));
    }
}

