/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.lib.kyori.adventure.text;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import nl.rslot.ssx.lib.jetbrains-annotations.NotNull;
import nl.rslot.ssx.lib.jetbrains-annotations.Nullable;
import nl.rslot.ssx.lib.jetbrains-annotations.VisibleForTesting;
import nl.rslot.ssx.lib.kyori.adventure.internal.Internals;
import nl.rslot.ssx.lib.kyori.adventure.internal.properties.AdventureProperties;
import nl.rslot.ssx.lib.kyori.adventure.text.AbstractComponent;
import nl.rslot.ssx.lib.kyori.adventure.text.AbstractComponentBuilder;
import nl.rslot.ssx.lib.kyori.adventure.text.Component;
import nl.rslot.ssx.lib.kyori.adventure.text.ComponentLike;
import nl.rslot.ssx.lib.kyori.adventure.text.LegacyFormattingDetected;
import nl.rslot.ssx.lib.kyori.adventure.text.TextComponent;
import nl.rslot.ssx.lib.kyori.adventure.text.format.Style;
import nl.rslot.ssx.lib.kyori.adventure.util.Nag;

class TextComponentImpl
extends AbstractComponent
implements TextComponent {
    private static final boolean WARN_WHEN_LEGACY_FORMATTING_DETECTED = Boolean.TRUE.equals(AdventureProperties.TEXT_WARN_WHEN_LEGACY_FORMATTING_DETECTED.value());
    @VisibleForTesting
    static final char SECTION_CHAR = '\u00a7';
    static final TextComponent EMPTY = TextComponentImpl.createDirect("");
    static final TextComponent NEWLINE = TextComponentImpl.createDirect("\n");
    static final TextComponent SPACE = TextComponentImpl.createDirect(" ");
    private final String content;

    static TextComponent create(@NotNull List<? extends ComponentLike> children, @NotNull Style style, @NotNull String content) {
        List<Component> filteredChildren = ComponentLike.asComponents(children, IS_NOT_EMPTY);
        if (filteredChildren.isEmpty() && style.isEmpty() && content.isEmpty()) {
            return Component.empty();
        }
        return new TextComponentImpl(filteredChildren, Objects.requireNonNull(style, "style"), Objects.requireNonNull(content, "content"));
    }

    TextComponent create0(@NotNull List<? extends ComponentLike> children, @NotNull Style style, @NotNull String content) {
        return TextComponentImpl.create(children, style, content);
    }

    @NotNull
    private static TextComponent createDirect(@NotNull String content) {
        return new TextComponentImpl(Collections.emptyList(), Style.empty(), content);
    }

    TextComponentImpl(@NotNull List<Component> children, @NotNull Style style, @NotNull String content) {
        super(children, style);
        LegacyFormattingDetected nag;
        this.content = content;
        if (WARN_WHEN_LEGACY_FORMATTING_DETECTED && (nag = this.warnWhenLegacyFormattingDetected()) != null) {
            Nag.print(nag);
        }
    }

    @VisibleForTesting
    @Nullable
    final LegacyFormattingDetected warnWhenLegacyFormattingDetected() {
        if (this.content.indexOf(167) != -1) {
            return new LegacyFormattingDetected(this);
        }
        return null;
    }

    @Override
    @NotNull
    public String content() {
        return this.content;
    }

    @Override
    @NotNull
    public TextComponent content(@NotNull String content) {
        if (Objects.equals(this.content, content)) {
            return this;
        }
        return this.create0(this.children, this.style, content);
    }

    @Override
    @NotNull
    public TextComponent children(@NotNull List<? extends ComponentLike> children) {
        return this.create0(children, this.style, this.content);
    }

    @Override
    @NotNull
    public TextComponent style(@NotNull Style style) {
        return this.create0(this.children, style, this.content);
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextComponentImpl)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        TextComponentImpl that = (TextComponentImpl)other;
        return Objects.equals(this.content, that.content);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.content.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return Internals.toString(this);
    }

    @Override
    @NotNull
    public TextComponent.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static class BuilderImpl
    extends AbstractComponentBuilder<TextComponent, TextComponent.Builder>
    implements TextComponent.Builder {
        private String content = "";

        BuilderImpl() {
        }

        BuilderImpl(@NotNull TextComponent component) {
            super(component);
            this.content = component.content();
        }

        @Override
        @NotNull
        public TextComponent.Builder content(@NotNull String content) {
            this.content = Objects.requireNonNull(content, "content");
            return this;
        }

        @Override
        @NotNull
        public String content() {
            return this.content;
        }

        @Override
        @NotNull
        public TextComponent build() {
            if (this.isEmpty()) {
                return Component.empty();
            }
            return TextComponentImpl.create(this.children, this.buildStyle(), this.content);
        }

        private boolean isEmpty() {
            return this.content.isEmpty() && this.children.isEmpty() && !this.hasStyle();
        }
    }
}

