/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.lib.nbtapi;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import nl.rslot.ssx.lib.nbtapi.NBTCompound;
import nl.rslot.ssx.lib.nbtapi.NBTList;
import nl.rslot.ssx.lib.nbtapi.NBTType;
import nl.rslot.ssx.lib.nbtapi.NbtApiException;
import nl.rslot.ssx.lib.nbtapi.utils.nmsmappings.ClassWrapper;
import nl.rslot.ssx.lib.nbtapi.utils.nmsmappings.ReflectionMethod;

public class NBTStringList
extends NBTList<String> {
    protected NBTStringList(NBTCompound owner, String name, NBTType type, Object list) {
        super(owner, name, type, list);
    }

    @Override
    public String get(int index) {
        try {
            Object ret = ReflectionMethod.LIST_GET_STRING.run(this.listObject, index);
            if (ret instanceof Optional) {
                return ((Optional)ret).orElse("");
            }
            return (String)ret;
        }
        catch (Exception ex) {
            throw new NbtApiException(ex);
        }
    }

    @Override
    protected Object asTag(String object) {
        try {
            Constructor<?> con = ClassWrapper.NMS_NBTTAGSTRING.getClazz().getDeclaredConstructor(String.class);
            con.setAccessible(true);
            return con.newInstance(object);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new NbtApiException("Error while wrapping the Object " + object + " to it's NMS object!", e);
        }
    }
}

