/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.placeholders;

import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import nl.rslot.ssx.Main;
import nl.rslot.ssx.ServerSelectorX;
import nl.rslot.ssx.lib.jetbrains-annotations.NotNull;
import nl.rslot.ssx.placeholders.GlobalPlaceholder;
import nl.rslot.ssx.placeholders.Placeholder;
import nl.rslot.ssx.placeholders.PlayerPlaceholder;
import nl.rslot.ssx.placeholders.Server;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class PapiExpansion
extends PlaceholderExpansion {
    public String onPlaceholderRequest(Player player, String identifier) {
        if (identifier.startsWith("server_")) {
            identifier = identifier.substring(7);
            StringBuilder serverName = new StringBuilder();
            for (char c : identifier.toCharArray()) {
                if (c == '_') break;
                serverName.append(c);
            }
            String placeholderName = identifier.substring(serverName.length() + 1);
            Server server = ServerSelectorX.getServer(serverName.toString());
            if (placeholderName.equals("status")) {
                String status = server != null ? "online" : "offline";
                return Main.getConfigurationManager().getMiscConfiguration().getString("placeholders.status-" + status, status);
            }
            if (server != null) {
                Placeholder placeholder = server.getPlaceholder(placeholderName);
                if (placeholder instanceof PlayerPlaceholder) {
                    return ((PlayerPlaceholder)placeholder).getValue((OfflinePlayer)player);
                }
                return ((GlobalPlaceholder)placeholder).getValue();
            }
            return "";
        }
        return null;
    }

    @NotNull
    public String getAuthor() {
        return String.join((CharSequence)", ", Main.getPlugin().getDescription().getAuthors());
    }

    @NotNull
    public String getIdentifier() {
        return "ssx";
    }

    @NotNull
    public String getVersion() {
        return Main.getPlugin().getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public boolean canRegister() {
        return true;
    }
}

