/*
 * Decompiled with CFR 0.152.
 */
package nl.rslot.ssx.placeholders;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import nl.rslot.ssx.Main;
import nl.rslot.ssx.lib.checkerframework.checker.nullness.qual.Nullable;
import nl.rslot.ssx.placeholders.GlobalPlaceholder;
import nl.rslot.ssx.placeholders.Placeholder;
import nl.rslot.ssx.placeholders.PlayerPlaceholder;
import nl.rslot.ssx.placeholders.Server;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PlaceholderReceiver {
    private Map<String, Server> servers = Collections.emptyMap();
    private String status;
    private long lastSuccess = 0L;
    private List<String> placeholderServers;
    private String networkId;
    private final String lobbyId;

    public PlaceholderReceiver() {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Main.getPlugin(), this::updatePlaceholders, 0L, 100L);
        this.lobbyId = UUID.randomUUID().toString();
    }

    public String getStatus() {
        return this.status;
    }

    public void loadConfiguration() {
        FileConfiguration config = Main.getConfigurationManager().getServerConfiguration();
        this.placeholderServers = config.getStringList("placeholder-servers");
        this.networkId = config.getString("network-id");
    }

    public void updatePlaceholders() {
        if (this.placeholderServers.size() == 0 || this.networkId == null) {
            return;
        }
        Object newStatus = "";
        for (String placeholderServer : this.placeholderServers) {
            try {
                this.updatePlaceholdersFrom(placeholderServer);
                this.lastSuccess = System.currentTimeMillis();
                newStatus = (String)newStatus + String.valueOf(ChatColor.GRAY) + placeholderServer + String.valueOf(ChatColor.GREEN) + " WORKING" + String.valueOf(ChatColor.RESET) + "\n";
                break;
            }
            catch (Exception e) {
                newStatus = (String)newStatus + String.valueOf(ChatColor.GRAY) + placeholderServer + String.valueOf(ChatColor.RED) + " " + e.getClass().getSimpleName() + ": " + e.getMessage() + String.valueOf(ChatColor.RESET) + "\n";
            }
        }
        this.status = newStatus;
        if (System.currentTimeMillis() - this.lastSuccess > 300000L) {
            this.servers = Collections.emptyMap();
        }
    }

    public void updatePlaceholdersFrom(String placeholderServer) throws IOException {
        byte[] data;
        JsonArray jsonPlayersArray = new JsonArray();
        for (Player player : Bukkit.getOnlinePlayers()) {
            jsonPlayersArray.add(player.getUniqueId().toString());
        }
        JsonObject requestJson = new JsonObject();
        requestJson.add("players", jsonPlayersArray);
        requestJson.addProperty("network", this.networkId);
        requestJson.addProperty("lobby", this.lobbyId);
        URLConnection connection = URI.create(placeholderServer + "/lobby").toURL().openConnection();
        connection.setDoOutput(true);
        try (OutputStream out = connection.getOutputStream();){
            data = requestJson.toString().getBytes();
            out.write(data);
        }
        try (InputStream in = connection.getInputStream();){
            data = in.readAllBytes();
            JsonObject repsonseJson = Main.JSON_PARSER.parse(new String(data)).getAsJsonObject();
            this.servers = PlaceholderReceiver.parseResponse(repsonseJson);
        }
    }

    public Map<String, Server> getServers() {
        return this.servers;
    }

    public @Nullable Server getServer(String name) {
        return this.servers.get(name);
    }

    private static Map<String, Server> parseResponse(JsonObject response) {
        JsonObject serversObject = response.get("servers").getAsJsonObject();
        HashMap<String, Server> newServers = new HashMap<String, Server>();
        for (Map.Entry<String, JsonElement> entry : serversObject.entrySet()) {
            String serverName = entry.getKey();
            JsonObject serverObject = entry.getValue().getAsJsonObject();
            JsonObject placeholdersObject = serverObject.get("placeholders").getAsJsonObject();
            HashMap<String, Placeholder> parsedPlaceholders = new HashMap<String, Placeholder>();
            for (Map.Entry<String, JsonElement> placeholderEntry : placeholdersObject.entrySet()) {
                String key = placeholderEntry.getKey();
                if (placeholderEntry.getValue().isJsonObject()) {
                    JsonObject values = placeholderEntry.getValue().getAsJsonObject();
                    HashMap<UUID, String> parsedValues = new HashMap<UUID, String>();
                    for (Map.Entry<String, JsonElement> valueEntry : values.entrySet()) {
                        parsedValues.put(UUID.fromString(valueEntry.getKey()), valueEntry.getValue().getAsString());
                    }
                    parsedPlaceholders.put(key, new PlayerPlaceholder(key, parsedValues));
                    continue;
                }
                if (!placeholderEntry.getValue().isJsonPrimitive()) continue;
                String value = placeholderEntry.getValue().getAsString();
                parsedPlaceholders.put(key, new GlobalPlaceholder(key, value));
            }
            newServers.put(serverName, new Server(serverName, parsedPlaceholders));
        }
        return newServers;
    }
}

