/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.ssx_connector;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import xyz.derkades.ssx_connector.Main;
import xyz.derkades.ssx_connector.PingLogger;
import xyz.derkades.ssx_connector.PlaceholderRegistry;
import xyz.derkades.ssx_connector.lib.gson.Gson;

public class PlaceholderSender
implements Runnable {
    private final Deque<String> addresses = new ArrayDeque<String>();

    @Override
    public void run() {
        Map<UUID, String> players;
        String s;
        FileConfiguration config = Main.instance.getConfig();
        if (this.addresses.isEmpty()) {
            config.getStringList("addresses").forEach(this.addresses::push);
            if (this.addresses.isEmpty()) {
                return;
            }
        }
        String address = !(s = this.addresses.pop().trim()).startsWith("https://") && !s.startsWith("http://") ? "http://" + s : s;
        this.debug(address, "Preparing to send data");
        String serverName = config.getString("server-name");
        this.debug(address, "Using server name '" + serverName + "'");
        if (serverName.isEmpty()) {
            this.debug(address, "Server name is empty! Not sending data");
            return;
        }
        this.debug(address, "Retrieving player list..");
        try {
            players = this.getPlayerList(address);
        }
        catch (MalformedURLException e) {
            PingLogger.logFail(address, "Invalid address");
            this.debug(e);
            return;
        }
        catch (IOException e) {
            PingLogger.logFail(address, "IOException: " + e.getMessage());
            this.debug(e);
            return;
        }
        this.debug(address, "Done. (" + players.size() + " players)");
        players.forEach((uuid, name) -> this.debug(address, " - " + uuid + ":" + name));
        this.debug(address, "Collecting placeholders..");
        PlaceholderRegistry.collectPlaceholders(players, placeholders -> Bukkit.getScheduler().runTaskAsynchronously((Plugin)Main.instance, () -> {
            try {
                this.sendPlaceholders(address, serverName, (Map<String, Object>)placeholders);
            }
            catch (MalformedURLException e) {
                PingLogger.logFail(address, "Invalid address");
                this.debug(e);
                return;
            }
            catch (IOException e) {
                PingLogger.logFail(address, "IOException: " + e.getMessage());
                this.debug(e);
                return;
            }
            PingLogger.logSuccess(address);
            ++Main.sendAmount;
            this.debug(address, "Data sent!");
        }));
    }

    private void sendPlaceholders(String address, String serverName, Map<String, Object> placeholders) throws IOException {
        String json = new Gson().toJson(placeholders).toString();
        this.debug(address, "Placeholders json: " + json);
        String parameters = String.format("server=%s&data=%s", this.encode(serverName), this.encode(json));
        HttpURLConnection connection = (HttpURLConnection)new URL(address).openConnection();
        connection.setRequestMethod("POST");
        connection.setDoOutput(true);
        DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());
        outputStream.writeBytes(parameters);
        if (connection.getResponseCode() != 200) {
            throw new IOException("Response code " + connection.getResponseCode());
        }
    }

    private Map<UUID, String> getPlayerList(String address) throws IOException {
        String responseString;
        HttpURLConnection connection = (HttpURLConnection)new URL(address + "/players").openConnection();
        if (connection.getResponseCode() != 200) {
            throw new IOException("Response code " + connection.getResponseCode());
        }
        InputStream inputStream = connection.getInputStream();
        BufferedReader streamReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        StringBuilder responseBuilder = new StringBuilder();
        while ((responseString = streamReader.readLine()) != null) {
            responseBuilder.append(responseString);
        }
        inputStream.close();
        Map map = new Gson().fromJson(responseBuilder.toString(), Map.class);
        HashMap<UUID, String> map2 = new HashMap<UUID, String>();
        map.forEach((k, v) -> map2.put(UUID.fromString(String.valueOf(k)), String.valueOf(v)));
        return map2;
    }

    private String encode(Object object) {
        try {
            return URLEncoder.encode(object.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private void debug(String address, String message) {
        if (Main.instance.getConfig().getBoolean("debug", false)) {
            Main.instance.getLogger().info("[Debug] " + address + " - " + message);
        }
    }

    private void debug(Exception e) {
        if (Main.instance.getConfig().getBoolean("debug", false)) {
            e.printStackTrace();
        }
    }
}

