/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx;

import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import xyz.derkades.serverselectorx.Main;
import xyz.derkades.serverselectorx.actions.Action;
import xyz.derkades.serverselectorx.lib.derkutils.Cooldown;
import xyz.derkades.serverselectorx.lib.derkutils.bukkit.Colors;
import xyz.derkades.serverselectorx.lib.nbtapi.NBTItem;

public class ItemClickListener
implements Listener {
    @EventHandler(priority=EventPriority.HIGH)
    public void onInteract(PlayerInteractEvent event) {
        if (event.getAction() == org.bukkit.event.block.Action.PHYSICAL) {
            return;
        }
        FileConfiguration inventory = Main.getConfigurationManager().getInventoryConfiguration();
        if (event.isCancelled() && inventory.getBoolean("ignore-cancelled", false)) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = player.getInventory().getItemInHand();
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        if (!this.checkCooldown(player, "ssxitemglobal", 100L, false)) {
            return;
        }
        NBTItem nbt = new NBTItem(item);
        if (!nbt.hasKey("SSXItem").booleanValue()) {
            return;
        }
        String itemName = nbt.getString("SSXItem");
        FileConfiguration config = Main.getConfigurationManager().getItemConfiguration(itemName);
        if (config == null) {
            player.sendMessage("No configuration file exists for an item with the name '" + itemName + "'.");
            return;
        }
        if (config.isInt("cooldown") && !this.checkCooldown(player, "ssxitem" + itemName, config.getInt("cooldown"), true)) {
            return;
        }
        ArrayList<String> actions = new ArrayList<String>(config.getStringList("actions"));
        if (config.isList("left-click-actions") && (event.getAction() == org.bukkit.event.block.Action.LEFT_CLICK_AIR || event.getAction() == org.bukkit.event.block.Action.LEFT_CLICK_BLOCK)) {
            actions.addAll(config.getStringList("left-click-actions"));
        }
        if (config.isList("right-click-actions") && (event.getAction() == org.bukkit.event.block.Action.RIGHT_CLICK_AIR || event.getAction() == org.bukkit.event.block.Action.RIGHT_CLICK_BLOCK)) {
            actions.addAll(config.getStringList("right-click-actions"));
        }
        Action.runActions(player, actions);
        boolean cancel = inventory.getBoolean("cancel-click-event", false);
        if (cancel) {
            event.setCancelled(true);
        }
    }

    private boolean checkCooldown(Player player, String id, long duration, boolean message) {
        long timeLeft = Cooldown.getCooldown(id = id + player.getName());
        if (timeLeft > 0L) {
            if (message && Main.getConfigurationManager().getMiscConfiguration().isString("cooldown-message")) {
                player.sendMessage(Colors.parseColors(String.format(Main.getConfigurationManager().getMiscConfiguration().getString("cooldown-message"), (double)timeLeft / 1000.0)));
            }
            return false;
        }
        Cooldown.addCooldown(id, duration);
        return true;
    }
}

