/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.configuration;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import xyz.derkades.serverselectorx.Main;
import xyz.derkades.serverselectorx.lib.gson.JsonParser;
import xyz.derkades.serverselectorx.placeholders.Server;

public class ConfigSync {
    private final Logger logger = Main.getPlugin().getLogger();

    public ConfigSync() {
        FileConfiguration configSync = Main.getConfigurationManager().getSyncConfiguration();
        if (!configSync.getBoolean("enabled", false)) {
            return;
        }
        long interval = (long)(configSync.getInt("interval") * 60) * 20L;
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Main.getPlugin(), this::sync, 20L, interval);
    }

    private static String encode(String string) {
        try {
            return URLEncoder.encode(string, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getBaseUrl(String method) {
        FileConfiguration configSync = Main.getConfigurationManager().getSyncConfiguration();
        return "http://" + configSync.getString("address") + (method.equals("") ? "" : "/" + method);
    }

    private boolean testConnectivity() {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(ConfigSync.getBaseUrl("listfiles") + "?dir=.").openConnection();
            conn.setConnectTimeout(1000);
            conn.connect();
            if (conn.getResponseCode() == 200) {
                return true;
            }
            if (conn.getResponseCode() == 403) {
                this.logger.warning("Failed to sync files, is files-api enabled on the other server?");
                return false;
            }
            this.logger.warning("Received bad request response code");
            this.logger.warning("This is probably an issue with the plugin");
            this.logger.warning("Make sure that you are using the latest and/or same version everywhere.");
            return false;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            this.logger.warning("Connection error.");
            this.logger.warning("Is the server down? Is the address correct? Firewall?");
            this.logger.warning("URL: " + ConfigSync.getBaseUrl(""));
            return false;
        }
    }

    private void addFilesInDirectory(String directory, List<String> files) throws IOException {
        if (directory.endsWith("/")) {
            this.logger.warning("Skipped directory '" + directory + "', directories should not end with a slash.");
            return;
        }
        URL url = new URL(ConfigSync.getBaseUrl("listfiles") + "?dir=" + ConfigSync.encode(directory));
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (connection.getResponseCode() != 200) {
            this.logger.warning("Skipped directory '" + directory + "', received non-200 HTTP status.");
            this.logger.warning("Status: " + connection.getResponseCode());
            return;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            JsonParser.parseReader(reader).getAsJsonArray().forEach(e -> files.add(e.getAsString()));
        }
    }

    public List<String> getFilesToSync() {
        FileConfiguration configSync = Main.getConfigurationManager().getSyncConfiguration();
        ArrayList<String> files = new ArrayList<String>();
        configSync.getStringList("files").stream().map(s -> Main.getPlugin().getDataFolder().getPath() + "/" + s).forEach(files::add);
        for (String dir : configSync.getStringList("directories")) {
            try {
                this.addFilesInDirectory(dir, files);
            }
            catch (IOException e) {
                this.logger.warning("An error occured while trying to get a list of files in the directory " + dir);
                e.printStackTrace();
            }
        }
        configSync.getStringList("exclude").forEach(files::remove);
        return files;
    }

    private InputStream getFileContent(String file) throws IOException {
        return new URL(ConfigSync.getBaseUrl("getfile") + "?file=" + ConfigSync.encode(file)).openConnection().getInputStream();
    }

    public void sync() {
        FileConfiguration configSync = Main.getConfigurationManager().getSyncConfiguration();
        this.logger.info("Starting config sync..");
        try {
            new URL("http://" + configSync.getString("address"));
        }
        catch (MalformedURLException e) {
            this.logger.severe("The address you entered seems to be incorrectly formatted.");
            this.logger.severe("It must be formatted like this: 173.45.16.208:8888");
            return;
        }
        if (!this.testConnectivity()) {
            return;
        }
        File dataFolder = Main.getPlugin().getDataFolder();
        if (configSync.getBoolean("delete", false)) {
            File[] toDelete;
            for (File dir : toDelete = new File[]{new File(dataFolder, "item"), new File(dataFolder, "command"), new File(dataFolder, "menu")}) {
                try {
                    Files.delete(dir.toPath());
                }
                catch (IOException e) {
                    this.logger.warning("Failed to delete directory" + dir.getPath());
                }
            }
        }
        for (String fileName : this.getFilesToSync()) {
            try {
                InputStream input = this.getFileContent(fileName);
                Throwable throwable = null;
                try {
                    File file = new File(fileName);
                    file.getParentFile().mkdirs();
                    Files.copy(input, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (input == null) continue;
                    if (throwable != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    input.close();
                }
            }
            catch (IOException e) {
                this.logger.warning("An error occured while trying sync file " + fileName);
                e.printStackTrace();
            }
        }
        this.logger.info("File sync done! The plugin will now reload.");
        try {
            Main.getConfigurationManager().reload();
            this.logger.info("Reload complete.");
        }
        catch (IOException e) {
            Main.getPlugin().getLogger().warning("Oh no! There was a syntax error in the config file pulledfrom the other server. The plugin will probably stop working. For a detailed error report, use /ssx reload on the other server.");
        }
        Server.clear();
        Bukkit.getScheduler().runTask((Plugin)Main.getPlugin(), () -> {
            List commands = configSync.getStringList("after-sync-commands");
            if (!commands.isEmpty()) {
                this.logger.info("Running after-sync-commands");
                commands.forEach(c -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)c));
            }
        });
    }
}

