/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.configuration;

import java.io.File;
import java.io.IOException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import xyz.derkades.serverselectorx.Main;
import xyz.derkades.serverselectorx.lib.derkutils.FileUtils;

public class ConfigurationManager {
    private static final File CONFIG_DIR = new File(Main.getPlugin().getDataFolder(), "config");
    private final Map<StandardConfigFile, FileConfiguration> STANDARD_FILES = new EnumMap<StandardConfigFile, FileConfiguration>(StandardConfigFile.class);
    private final Map<MultiConfigFile, Map<String, FileConfiguration>> MULTI_FILES = new EnumMap<MultiConfigFile, Map<String, FileConfiguration>>(MultiConfigFile.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() throws IOException {
        File dir = Main.getPlugin().getDataFolder();
        File configDir = new File(dir, "config");
        configDir.mkdirs();
        Map<Enum, Object> map = this.STANDARD_FILES;
        synchronized (map) {
            for (StandardConfigFile standardConfigFile : StandardConfigFile.values()) {
                this.STANDARD_FILES.put(standardConfigFile, (FileConfiguration)standardConfigFile.copyLoad());
            }
        }
        map = this.MULTI_FILES;
        synchronized (map) {
            for (Enum enum_ : MultiConfigFile.values()) {
                HashMap files = new HashMap();
                ((MultiConfigFile)enum_).copyLoad(files);
                this.MULTI_FILES.put((MultiConfigFile)enum_, files);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileConfiguration getCommandConfiguration(String name) {
        Map<MultiConfigFile, Map<String, FileConfiguration>> map = this.MULTI_FILES;
        synchronized (map) {
            return this.MULTI_FILES.get((Object)MultiConfigFile.COMMAND).get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> listCommandConfigurations() {
        Map<MultiConfigFile, Map<String, FileConfiguration>> map = this.MULTI_FILES;
        synchronized (map) {
            return this.MULTI_FILES.get((Object)MultiConfigFile.COMMAND).keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileConfiguration getItemConfiguration(String name) {
        Map<MultiConfigFile, Map<String, FileConfiguration>> map = this.MULTI_FILES;
        synchronized (map) {
            return this.MULTI_FILES.get((Object)MultiConfigFile.ITEM).get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> listItemConfigurations() {
        Map<MultiConfigFile, Map<String, FileConfiguration>> map = this.MULTI_FILES;
        synchronized (map) {
            return this.MULTI_FILES.get((Object)MultiConfigFile.ITEM).keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileConfiguration getMenuConfiguration(String name) {
        Map<MultiConfigFile, Map<String, FileConfiguration>> map = this.MULTI_FILES;
        synchronized (map) {
            return this.MULTI_FILES.get((Object)MultiConfigFile.MENU).get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> listMenuConfigurations() {
        Map<MultiConfigFile, Map<String, FileConfiguration>> map = this.MULTI_FILES;
        synchronized (map) {
            return this.MULTI_FILES.get((Object)MultiConfigFile.MENU).keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileConfiguration getApiConfiguration() {
        Map<StandardConfigFile, FileConfiguration> map = this.STANDARD_FILES;
        synchronized (map) {
            return this.STANDARD_FILES.get((Object)StandardConfigFile.API);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileConfiguration getInventoryConfiguration() {
        Map<StandardConfigFile, FileConfiguration> map = this.STANDARD_FILES;
        synchronized (map) {
            return this.STANDARD_FILES.get((Object)StandardConfigFile.INVENTORY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileConfiguration getJoinConfiguration() {
        Map<StandardConfigFile, FileConfiguration> map = this.STANDARD_FILES;
        synchronized (map) {
            return this.STANDARD_FILES.get((Object)StandardConfigFile.JOIN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileConfiguration getMiscConfiguration() {
        Map<StandardConfigFile, FileConfiguration> map = this.STANDARD_FILES;
        synchronized (map) {
            return this.STANDARD_FILES.get((Object)StandardConfigFile.MISC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileConfiguration getSyncConfiguration() {
        Map<StandardConfigFile, FileConfiguration> map = this.STANDARD_FILES;
        synchronized (map) {
            return this.STANDARD_FILES.get((Object)StandardConfigFile.SYNC);
        }
    }

    static /* synthetic */ File access$000() {
        return CONFIG_DIR;
    }

    private static enum MultiConfigFile {
        COMMAND(new File(Main.getPlugin().getDataFolder(), "command"), "/command.yml", "servers.yml"),
        ITEM(new File(Main.getPlugin().getDataFolder(), "item"), "/item.yml", "compass.yml"),
        MENU(new File(Main.getPlugin().getDataFolder(), "menu"), "/menu.yml", "serverselector.yml");

        private final File dir;
        private final String defaultFileInJar;
        private final String defaultFileOutsideJar;

        private MultiConfigFile(File dir, String defaultFileInJar, String defaultFileOutsideJar) {
            this.dir = dir;
            this.defaultFileInJar = defaultFileInJar;
            this.defaultFileOutsideJar = defaultFileOutsideJar;
        }

        private void copyLoad(Map<String, FileConfiguration> dest) throws IOException {
            if (!this.dir.exists()) {
                this.dir.mkdir();
                FileUtils.copyOutOfJar(((Object)((Object)this)).getClass(), this.defaultFileInJar, new File(this.dir, this.defaultFileOutsideJar));
            }
            for (File file : this.dir.listFiles()) {
                if (!file.getName().endsWith(".yml")) continue;
                dest.put(MultiConfigFile.configName(file), (FileConfiguration)YamlConfiguration.loadConfiguration((File)file));
            }
        }

        private static String configName(File file) {
            return file.getName().substring(0, file.getName().length() - 4);
        }
    }

    private static enum StandardConfigFile {
        API(new File(ConfigurationManager.access$000(), "api.yml")),
        INVENTORY(new File(ConfigurationManager.access$000(), "inventory.yml")),
        JOIN(new File(ConfigurationManager.access$000(), "join.yml")),
        MISC(new File(ConfigurationManager.access$000(), "misc.yml")),
        SYNC(new File(ConfigurationManager.access$000(), "sync.yml"));

        private final File file;

        private StandardConfigFile(File file) {
            this.file = file;
        }

        private YamlConfiguration copyLoad() throws IOException {
            if (!this.file.exists()) {
                FileUtils.copyOutOfJar(((Object)((Object)this)).getClass(), "/config/" + this.file.getName(), this.file);
            }
            return YamlConfiguration.loadConfiguration((File)this.file);
        }
    }
}

