/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.http;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.bukkit.configuration.file.FileConfiguration;
import xyz.derkades.serverselectorx.Main;
import xyz.derkades.serverselectorx.lib.commons-lang3.Validate;
import xyz.derkades.serverselectorx.lib.grizzly.http.Method;
import xyz.derkades.serverselectorx.lib.grizzly.http.server.HttpHandler;
import xyz.derkades.serverselectorx.lib.grizzly.http.server.Request;
import xyz.derkades.serverselectorx.lib.grizzly.http.server.Response;
import xyz.derkades.serverselectorx.lib.grizzly.http.util.HttpStatus;

public class GetFile
extends HttpHandler {
    @Override
    public void service(Request request, Response response) throws Exception {
        Validate.isTrue(request.getMethod() == Method.GET, "Must use GET method", new Object[0]);
        FileConfiguration api = Main.getConfigurationManager().getApiConfiguration();
        if (!api.getBoolean("files-api")) {
            response.getWriter().write("Files API disabled\n");
            response.setStatus(HttpStatus.FORBIDDEN_403);
            return;
        }
        String filePath = request.getParameter("file");
        if (filePath == null) {
            response.getWriter().write("File not specified\n");
            response.setStatus(HttpStatus.BAD_REQUEST_400);
            return;
        }
        Path file = Paths.get(filePath, new String[0]);
        String type = Files.probeContentType(file);
        response.setContentType(type != null ? type : "application/octet-stream");
        Files.copy(file, response.getOutputStream());
    }
}

