/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.http;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import xyz.derkades.serverselectorx.Main;
import xyz.derkades.serverselectorx.lib.commons-lang3.Validate;
import xyz.derkades.serverselectorx.lib.grizzly.http.Method;
import xyz.derkades.serverselectorx.lib.grizzly.http.server.HttpHandler;
import xyz.derkades.serverselectorx.lib.grizzly.http.server.Request;
import xyz.derkades.serverselectorx.lib.grizzly.http.server.Response;
import xyz.derkades.serverselectorx.lib.grizzly.http.util.HttpStatus;
import xyz.derkades.serverselectorx.placeholders.GlobalPlaceholder;
import xyz.derkades.serverselectorx.placeholders.Placeholder;
import xyz.derkades.serverselectorx.placeholders.PlayerPlaceholder;
import xyz.derkades.serverselectorx.placeholders.Server;

public class Root
extends HttpHandler {
    @Override
    public void service(Request request, Response response) throws Exception {
        switch (request.getMethod().getMethodString()) {
            case "GET": {
                response.setContentType("text/json");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("version", Main.getPlugin().getDescription().getVersion());
                map.put("servers", Server.getServers());
                String json = Main.GSON.toJson(map);
                response.getWriter().write(json);
                break;
            }
            case "POST": {
                String serverName = request.getParameter("server");
                String placeholdersJsonString = request.getParameter("data");
                Logger logger = Main.getPlugin().getLogger();
                if (serverName.equals("")) {
                    logger.warning("Ignoring request with empty server name from " + request.getRemoteAddr());
                    logger.warning("Set the server name in the connector configuration file.");
                    return;
                }
                Map receivedPlaceholders = Main.GSON.fromJson(placeholdersJsonString, Map.class);
                HashMap<String, Placeholder> parsedPlaceholders = new HashMap<String, Placeholder>();
                receivedPlaceholders.forEach((k, v) -> {
                    if (v instanceof String) {
                        parsedPlaceholders.put((String)k, new GlobalPlaceholder((String)k, (String)v));
                    } else if (v instanceof Map) {
                        parsedPlaceholders.put((String)k, new PlayerPlaceholder((String)k, ((Map)v).entrySet().stream().collect(Collectors.toMap(e -> UUID.fromString((String)e.getKey()), Map.Entry::getValue))));
                    } else {
                        Main.getPlugin().getLogger().warning("Invalid placeholder value format (" + k + "; " + v + ")");
                    }
                });
                Server server = Server.getServer(serverName);
                server.updatePlaceholders(parsedPlaceholders);
                break;
            }
            default: {
                response.setStatus(HttpStatus.METHOD_NOT_ALLOWED_405);
            }
        }
        Validate.isTrue(request.getMethod() == Method.GET, "Must use GET method", new Object[0]);
    }
}

