/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import xyz.derkades.serverselectorx.lib.grizzly.Connection;
import xyz.derkades.serverselectorx.lib.grizzly.ConnectionProbe;
import xyz.derkades.serverselectorx.lib.grizzly.IOEvent;
import xyz.derkades.serverselectorx.lib.grizzly.IOStrategy;
import xyz.derkades.serverselectorx.lib.grizzly.Processor;
import xyz.derkades.serverselectorx.lib.grizzly.ProcessorSelector;
import xyz.derkades.serverselectorx.lib.grizzly.Transport;
import xyz.derkades.serverselectorx.lib.grizzly.TransportProbe;
import xyz.derkades.serverselectorx.lib.grizzly.attributes.AttributeBuilder;
import xyz.derkades.serverselectorx.lib.grizzly.memory.MemoryManager;
import xyz.derkades.serverselectorx.lib.grizzly.monitoring.DefaultMonitoringConfig;
import xyz.derkades.serverselectorx.lib.grizzly.monitoring.MonitoringAware;
import xyz.derkades.serverselectorx.lib.grizzly.monitoring.MonitoringConfig;
import xyz.derkades.serverselectorx.lib.grizzly.threadpool.ThreadPoolConfig;
import xyz.derkades.serverselectorx.lib.grizzly.threadpool.ThreadPoolProbe;
import xyz.derkades.serverselectorx.lib.grizzly.utils.StateHolder;

public abstract class AbstractTransport
implements Transport {
    protected String name;
    protected volatile boolean isBlocking;
    protected volatile boolean isStandalone;
    protected final StateHolder<Transport.State> state;
    protected Processor processor;
    protected ProcessorSelector processorSelector;
    protected IOStrategy strategy;
    protected MemoryManager memoryManager;
    protected ExecutorService workerThreadPool;
    protected ExecutorService kernelPool;
    protected AttributeBuilder attributeBuilder;
    protected int readBufferSize;
    protected int writeBufferSize;
    protected ThreadPoolConfig workerPoolConfig;
    protected ThreadPoolConfig kernelPoolConfig;
    protected boolean managedWorkerPool = true;
    protected long writeTimeout = TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS);
    protected long readTimeout = TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS);
    protected final DefaultMonitoringConfig<TransportProbe> transportMonitoringConfig = new DefaultMonitoringConfig<TransportProbe>(TransportProbe.class){

        @Override
        public Object createManagementObject() {
            return AbstractTransport.this.createJmxManagementObject();
        }
    };
    protected final DefaultMonitoringConfig<ConnectionProbe> connectionMonitoringConfig = new DefaultMonitoringConfig<ConnectionProbe>(ConnectionProbe.class);
    protected final DefaultMonitoringConfig<ThreadPoolProbe> threadPoolMonitoringConfig = new DefaultMonitoringConfig<ThreadPoolProbe>(ThreadPoolProbe.class);

    public AbstractTransport(String name) {
        this.name = name;
        this.state = new StateHolder<Transport.State>(Transport.State.STOPPED);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        AbstractTransport.notifyProbesConfigChanged(this);
    }

    @Override
    public boolean isBlocking() {
        return this.isBlocking;
    }

    @Override
    public void configureBlocking(boolean isBlocking) {
        this.isBlocking = isBlocking;
        AbstractTransport.notifyProbesConfigChanged(this);
    }

    @Override
    public boolean isStandalone() {
        return this.isStandalone;
    }

    @Override
    public StateHolder<Transport.State> getState() {
        return this.state;
    }

    @Override
    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    @Override
    public void setReadBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
        AbstractTransport.notifyProbesConfigChanged(this);
    }

    @Override
    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    @Override
    public void setWriteBufferSize(int writeBufferSize) {
        this.writeBufferSize = writeBufferSize;
        AbstractTransport.notifyProbesConfigChanged(this);
    }

    @Override
    public boolean isStopped() {
        Transport.State currentState = this.state.getState();
        return currentState == Transport.State.STOPPED || currentState == Transport.State.STOPPING;
    }

    @Override
    public boolean isPaused() {
        return this.state.getState() == Transport.State.PAUSED;
    }

    @Override
    public Processor obtainProcessor(IOEvent ioEvent, Connection connection) {
        if (this.processor != null && this.processor.isInterested(ioEvent)) {
            return this.processor;
        }
        if (this.processorSelector != null) {
            return this.processorSelector.select(ioEvent, connection);
        }
        return null;
    }

    @Override
    public Processor getProcessor() {
        return this.processor;
    }

    @Override
    public void setProcessor(Processor processor) {
        this.processor = processor;
        AbstractTransport.notifyProbesConfigChanged(this);
    }

    @Override
    public ProcessorSelector getProcessorSelector() {
        return this.processorSelector;
    }

    @Override
    public void setProcessorSelector(ProcessorSelector selector) {
        this.processorSelector = selector;
        AbstractTransport.notifyProbesConfigChanged(this);
    }

    @Override
    public IOStrategy getIOStrategy() {
        return this.strategy;
    }

    @Override
    public void setIOStrategy(IOStrategy IOStrategy2) {
        this.strategy = IOStrategy2;
        ThreadPoolConfig strategyConfig = IOStrategy2.createDefaultWorkerPoolConfig(this);
        if (strategyConfig == null) {
            this.workerPoolConfig = null;
        } else if (this.workerPoolConfig == null) {
            this.setWorkerThreadPoolConfig(strategyConfig);
        }
        AbstractTransport.notifyProbesConfigChanged(this);
    }

    @Override
    public MemoryManager getMemoryManager() {
        return this.memoryManager;
    }

    @Override
    public void setMemoryManager(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
        AbstractTransport.notifyProbesConfigChanged(this);
    }

    @Override
    public ExecutorService getWorkerThreadPool() {
        return this.workerThreadPool;
    }

    @Override
    public ExecutorService getKernelThreadPool() {
        return this.kernelPool;
    }

    @Override
    public void setKernelThreadPool(ExecutorService kernelPool) {
        this.kernelPool = kernelPool;
    }

    @Override
    public void setKernelThreadPoolConfig(ThreadPoolConfig kernelPoolConfig) {
        if (this.isStopped()) {
            this.kernelPoolConfig = kernelPoolConfig;
        }
    }

    @Override
    public void setWorkerThreadPoolConfig(ThreadPoolConfig workerPoolConfig) {
        if (this.isStopped()) {
            this.workerPoolConfig = workerPoolConfig;
        }
    }

    @Override
    public ThreadPoolConfig getKernelThreadPoolConfig() {
        return this.isStopped() ? this.kernelPoolConfig : this.kernelPoolConfig.copy();
    }

    @Override
    public ThreadPoolConfig getWorkerThreadPoolConfig() {
        return this.isStopped() ? this.workerPoolConfig : this.workerPoolConfig.copy();
    }

    @Override
    public void setWorkerThreadPool(ExecutorService threadPool) {
        this.managedWorkerPool = false;
        if (threadPool instanceof MonitoringAware && this.threadPoolMonitoringConfig.hasProbes()) {
            ((MonitoringAware)((Object)threadPool)).getMonitoringConfig().addProbes(this.threadPoolMonitoringConfig.getProbes());
        }
        this.setWorkerThreadPool0(threadPool);
    }

    protected void setWorkerThreadPool0(ExecutorService threadPool) {
        this.workerThreadPool = threadPool;
        AbstractTransport.notifyProbesConfigChanged(this);
    }

    protected void setKernelPool0(ExecutorService kernelPool) {
        this.kernelPool = kernelPool;
    }

    @Override
    public AttributeBuilder getAttributeBuilder() {
        return this.attributeBuilder;
    }

    @Override
    public void setAttributeBuilder(AttributeBuilder attributeBuilder) {
        this.attributeBuilder = attributeBuilder;
        AbstractTransport.notifyProbesConfigChanged(this);
    }

    protected abstract void closeConnection(Connection var1) throws IOException;

    @Override
    public MonitoringConfig<ConnectionProbe> getConnectionMonitoringConfig() {
        return this.connectionMonitoringConfig;
    }

    @Override
    public MonitoringConfig<TransportProbe> getMonitoringConfig() {
        return this.transportMonitoringConfig;
    }

    @Override
    public MonitoringConfig<ThreadPoolProbe> getThreadPoolMonitoringConfig() {
        return this.threadPoolMonitoringConfig;
    }

    @Override
    public long getReadTimeout(TimeUnit timeUnit) {
        if (this.readTimeout <= 0L) {
            return -1L;
        }
        return timeUnit.convert(this.readTimeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setReadTimeout(long timeout, TimeUnit timeUnit) {
        this.readTimeout = timeout <= 0L ? -1L : TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
    }

    @Override
    public long getWriteTimeout(TimeUnit timeUnit) {
        if (this.writeTimeout <= 0L) {
            return -1L;
        }
        return timeUnit.convert(this.writeTimeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public void setWriteTimeout(long timeout, TimeUnit timeUnit) {
        this.writeTimeout = timeout <= 0L ? -1L : TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
    }

    protected static void notifyProbesBeforeStart(AbstractTransport transport) {
        TransportProbe[] probes = transport.transportMonitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (TransportProbe probe : probes) {
                probe.onBeforeStartEvent(transport);
            }
        }
    }

    protected static void notifyProbesBeforeStop(AbstractTransport transport) {
        TransportProbe[] probes = transport.transportMonitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (TransportProbe probe : probes) {
                probe.onBeforeStopEvent(transport);
            }
        }
    }

    protected static void notifyProbesStop(AbstractTransport transport) {
        TransportProbe[] probes = transport.transportMonitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (TransportProbe probe : probes) {
                probe.onStopEvent(transport);
            }
        }
    }

    protected static void notifyProbesBeforePause(AbstractTransport transport) {
        TransportProbe[] probes = transport.transportMonitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (TransportProbe probe : probes) {
                probe.onBeforePauseEvent(transport);
            }
        }
    }

    protected static void notifyProbesPause(AbstractTransport transport) {
        TransportProbe[] probes = transport.transportMonitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (TransportProbe probe : probes) {
                probe.onPauseEvent(transport);
            }
        }
    }

    protected static void notifyProbesBeforeResume(AbstractTransport transport) {
        TransportProbe[] probes = transport.transportMonitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (TransportProbe probe : probes) {
                probe.onBeforeStartEvent(transport);
            }
        }
    }

    protected static void notifyProbesConfigChanged(AbstractTransport transport) {
        TransportProbe[] probes = transport.transportMonitoringConfig.getProbesUnsafe();
        if (probes != null) {
            for (TransportProbe probe : probes) {
                probe.onConfigChangeEvent(transport);
            }
        }
    }

    @Override
    @Deprecated
    public void stop() throws IOException {
        this.shutdownNow();
    }

    protected abstract Object createJmxManagementObject();
}

