/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly.asyncqueue;

import java.util.logging.Level;
import java.util.logging.Logger;
import xyz.derkades.serverselectorx.lib.grizzly.Cacheable;
import xyz.derkades.serverselectorx.lib.grizzly.CompletionHandler;
import xyz.derkades.serverselectorx.lib.grizzly.Connection;
import xyz.derkades.serverselectorx.lib.grizzly.Grizzly;
import xyz.derkades.serverselectorx.lib.grizzly.asyncqueue.AsyncQueue;
import xyz.derkades.serverselectorx.lib.grizzly.localization.LogMessages;
import xyz.derkades.serverselectorx.lib.grizzly.utils.DebugPoint;

public abstract class AsyncQueueRecord<R>
implements Cacheable {
    private static final Logger LOGGER = Grizzly.logger(AsyncQueue.class);
    protected Connection connection;
    protected Object message;
    protected CompletionHandler completionHandler;
    protected boolean isRecycled = false;
    protected DebugPoint recycleTrack;

    protected AsyncQueueRecord() {
    }

    public AsyncQueueRecord(Connection connection, Object message, CompletionHandler completionHandler) {
        this.set(connection, message, completionHandler);
    }

    protected final void set(Connection connection, Object message, CompletionHandler completionHandler) {
        this.checkRecycled();
        this.connection = connection;
        this.message = message;
        this.completionHandler = completionHandler;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public final <T> T getMessage() {
        this.checkRecycled();
        return (T)this.message;
    }

    public final void setMessage(Object message) {
        this.checkRecycled();
        this.message = message;
    }

    public abstract R getCurrentResult();

    public void notifyFailure(Throwable e) {
        if (this.completionHandler != null) {
            this.completionHandler.failed(e);
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, LogMessages.FINE_GRIZZLY_ASYNCQUEUE_ERROR_NOCALLBACK_ERROR(e));
        }
    }

    public final void notifyIncomplete() {
        if (this.completionHandler != null) {
            this.completionHandler.updated(this.getCurrentResult());
        }
    }

    protected final void checkRecycled() {
        if (Grizzly.isTrackingThreadCache() && this.isRecycled) {
            DebugPoint track = this.recycleTrack;
            if (track != null) {
                throw new IllegalStateException("AsyncReadQueueRecord has been recycled at: " + track);
            }
            throw new IllegalStateException("AsyncReadQueueRecord has been recycled");
        }
    }
}

