/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly.http;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import xyz.derkades.serverselectorx.lib.grizzly.http.HttpRequestPacket;
import xyz.derkades.serverselectorx.lib.grizzly.http.Protocol;
import xyz.derkades.serverselectorx.lib.grizzly.http.util.DataChunk;
import xyz.derkades.serverselectorx.lib.grizzly.http.util.Header;
import xyz.derkades.serverselectorx.lib.grizzly.http.util.HttpUtils;
import xyz.derkades.serverselectorx.lib.grizzly.utils.ArraySet;

public final class CompressionConfig {
    private CompressionMode compressionMode;
    private int compressionMinSize;
    private final ArraySet<String> compressibleMimeTypes = new ArraySet<String>(String.class);
    private final ArraySet<String> noCompressionUserAgents = new ArraySet<String>(String.class);
    private boolean decompressionEnabled;

    public CompressionConfig() {
        this.compressionMode = CompressionMode.OFF;
    }

    public CompressionConfig(CompressionConfig compression) {
        this.set(compression);
    }

    public CompressionConfig(CompressionMode compressionMode, int compressionMinSize, Set<String> compressibleMimeTypes, Set<String> noCompressionUserAgents) {
        this(compressionMode, compressionMinSize, compressibleMimeTypes, noCompressionUserAgents, false);
    }

    public CompressionConfig(CompressionMode compressionMode, int compressionMinSize, Set<String> compressibleMimeTypes, Set<String> noCompressionUserAgents, boolean decompressionEnabled) {
        this.setCompressionMode(compressionMode);
        this.setCompressionMinSize(compressionMinSize);
        this.setCompressibleMimeTypes(compressibleMimeTypes);
        this.setNoCompressionUserAgents(noCompressionUserAgents);
        this.setDecompressionEnabled(decompressionEnabled);
    }

    public void set(CompressionConfig compression) {
        this.compressionMode = compression.compressionMode;
        this.compressionMinSize = compression.compressionMinSize;
        this.setCompressibleMimeTypes(compression.compressibleMimeTypes);
        this.setNoCompressionUserAgents(compression.noCompressionUserAgents);
        this.decompressionEnabled = compression.isDecompressionEnabled();
    }

    public CompressionMode getCompressionMode() {
        return this.compressionMode;
    }

    public void setCompressionMode(CompressionMode mode) {
        this.compressionMode = mode != null ? mode : CompressionMode.OFF;
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int compressionMinSize) {
        this.compressionMinSize = compressionMinSize;
    }

    @Deprecated
    public Set<String> getCompressableMimeTypes() {
        return this.getCompressibleMimeTypes();
    }

    @Deprecated
    public void setCompressableMimeTypes(Set<String> compressibleMimeTypes) {
        this.setCompressibleMimeTypes(compressibleMimeTypes);
    }

    @Deprecated
    public void setCompressableMimeTypes(String ... compressibleMimeTypes) {
        this.setCompressibleMimeTypes(compressibleMimeTypes);
    }

    public Set<String> getCompressibleMimeTypes() {
        return Collections.unmodifiableSet(this.compressibleMimeTypes);
    }

    public void setCompressibleMimeTypes(Set<String> compressibleMimeTypes) {
        this.compressibleMimeTypes.clear();
        if (compressibleMimeTypes != null && !compressibleMimeTypes.isEmpty()) {
            this.compressibleMimeTypes.addAll((Collection<String>)compressibleMimeTypes);
        }
    }

    public void setCompressibleMimeTypes(String ... compressibleMimeTypes) {
        this.compressibleMimeTypes.clear();
        if (compressibleMimeTypes.length > 0) {
            this.compressibleMimeTypes.addAll((String[])compressibleMimeTypes);
        }
    }

    public Set<String> getNoCompressionUserAgents() {
        return Collections.unmodifiableSet(this.noCompressionUserAgents);
    }

    public void setNoCompressionUserAgents(Set<String> noCompressionUserAgents) {
        this.noCompressionUserAgents.clear();
        if (noCompressionUserAgents != null && !noCompressionUserAgents.isEmpty()) {
            this.noCompressionUserAgents.addAll((Collection<String>)noCompressionUserAgents);
        }
    }

    public void setNoCompressionUserAgents(String ... noCompressionUserAgents) {
        this.noCompressionUserAgents.clear();
        if (noCompressionUserAgents.length > 0) {
            this.noCompressionUserAgents.addAll((String[])noCompressionUserAgents);
        }
    }

    public boolean isDecompressionEnabled() {
        return this.decompressionEnabled;
    }

    public void setDecompressionEnabled(boolean decompressionEnabled) {
        this.decompressionEnabled = decompressionEnabled;
    }

    public static boolean isClientSupportCompression(CompressionConfig compressionConfig, HttpRequestPacket request, String[] aliases) {
        CompressionMode mode = compressionConfig.getCompressionMode();
        switch (mode) {
            case OFF: {
                return false;
            }
        }
        if (Protocol.HTTP_1_1 != request.getProtocol()) {
            return false;
        }
        if (!CompressionConfig.isClientSupportContentEncoding(request, aliases)) {
            return false;
        }
        return mode == CompressionMode.FORCE || compressionConfig.checkUserAgent(request);
    }

    public boolean checkUserAgent(HttpRequestPacket request) {
        DataChunk userAgentValueDC;
        return this.noCompressionUserAgents.isEmpty() || (userAgentValueDC = request.getHeaders().getValue(Header.UserAgent)) == null || CompressionConfig.indexOf(this.noCompressionUserAgents.getArray(), userAgentValueDC) == -1;
    }

    public boolean checkMimeType(String contentType) {
        return this.compressibleMimeTypes.isEmpty() || CompressionConfig.indexOfStartsWith(this.compressibleMimeTypes.getArray(), contentType) != -1;
    }

    private static boolean isClientSupportContentEncoding(HttpRequestPacket request, String[] aliases) {
        DataChunk acceptEncodingDC = request.getHeaders().getValue(Header.AcceptEncoding);
        if (acceptEncodingDC == null) {
            return false;
        }
        String alias = null;
        int idx = -1;
        int len = aliases.length;
        for (int i = 0; i < len && (idx = acceptEncodingDC.indexOf(alias = aliases[i], 0)) == -1; ++i) {
        }
        if (idx == -1) {
            return false;
        }
        assert (alias != null);
        int qvalueStart = acceptEncodingDC.indexOf(';', idx + alias.length());
        if (qvalueStart != -1) {
            int qvalueEnd;
            int commaIdx = acceptEncodingDC.indexOf(',', qvalueStart = acceptEncodingDC.indexOf('=', qvalueStart));
            int n = qvalueEnd = commaIdx != -1 ? commaIdx : acceptEncodingDC.getLength();
            if (HttpUtils.convertQValueToFloat(acceptEncodingDC, qvalueStart + 1, qvalueEnd) == 0.0f) {
                return false;
            }
        }
        return true;
    }

    private static int indexOf(String[] aliases, DataChunk dc) {
        if (dc == null || dc.isNull()) {
            return -1;
        }
        for (int i = 0; i < aliases.length; ++i) {
            String alias = aliases[i];
            if (dc.indexOf(alias, 0) == -1) continue;
            return i;
        }
        return -1;
    }

    private static int indexOfStartsWith(String[] aliases, String s) {
        if (s == null || s.length() == 0) {
            return -1;
        }
        for (int i = 0; i < aliases.length; ++i) {
            String alias = aliases[i];
            if (!s.startsWith(alias)) continue;
            return i;
        }
        return -1;
    }

    public static enum CompressionMode implements CompressionModeI
    {
        OFF,
        ON,
        FORCE;


        public static CompressionMode fromString(String mode) {
            if ("on".equalsIgnoreCase(mode)) {
                return ON;
            }
            if ("force".equalsIgnoreCase(mode)) {
                return FORCE;
            }
            if ("off".equalsIgnoreCase(mode)) {
                return OFF;
            }
            throw new IllegalArgumentException("Compression mode is not recognized. Supported modes: " + Arrays.toString(CompressionMode.values()));
        }
    }

    public static interface CompressionModeI {
    }
}

