/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly.http;

import xyz.derkades.serverselectorx.lib.grizzly.Appendable;
import xyz.derkades.serverselectorx.lib.grizzly.Buffer;
import xyz.derkades.serverselectorx.lib.grizzly.ThreadCache;
import xyz.derkades.serverselectorx.lib.grizzly.http.HttpBrokenContent;
import xyz.derkades.serverselectorx.lib.grizzly.http.HttpHeader;
import xyz.derkades.serverselectorx.lib.grizzly.http.HttpPacket;
import xyz.derkades.serverselectorx.lib.grizzly.memory.Buffers;

public class HttpContent
extends HttpPacket
implements Appendable<HttpContent> {
    private static final ThreadCache.CachedTypeIndex<HttpContent> CACHE_IDX = ThreadCache.obtainIndex(HttpContent.class, 16);
    protected boolean isLast;
    protected Buffer content = Buffers.EMPTY_BUFFER;
    protected HttpHeader httpHeader;

    public static boolean isContent(HttpPacket httpPacket) {
        return httpPacket instanceof HttpContent;
    }

    public static boolean isBroken(HttpContent httpContent) {
        return httpContent instanceof HttpBrokenContent;
    }

    public static HttpContent create() {
        return HttpContent.create(null);
    }

    public static HttpContent create(HttpHeader httpHeader) {
        return HttpContent.create(httpHeader, false);
    }

    public static HttpContent create(HttpHeader httpHeader, boolean isLast) {
        return HttpContent.create(httpHeader, isLast, Buffers.EMPTY_BUFFER);
    }

    public static HttpContent create(HttpHeader httpHeader, boolean isLast, Buffer content) {
        content = content != null ? content : Buffers.EMPTY_BUFFER;
        HttpContent httpContent = ThreadCache.takeFromCache(CACHE_IDX);
        if (httpContent != null) {
            httpContent.httpHeader = httpHeader;
            httpContent.isLast = isLast;
            httpContent.content = content;
            return httpContent;
        }
        return new HttpContent(httpHeader, isLast, content);
    }

    public static Builder builder(HttpHeader httpHeader) {
        return new Builder().httpHeader(httpHeader);
    }

    protected HttpContent() {
        this(null);
    }

    protected HttpContent(HttpHeader httpHeader) {
        this.httpHeader = httpHeader;
    }

    protected HttpContent(HttpHeader httpHeader, boolean isLast, Buffer content) {
        this.httpHeader = httpHeader;
        this.isLast = isLast;
        this.content = content;
    }

    public Buffer getContent() {
        return this.content;
    }

    protected final void setContent(Buffer content) {
        this.content = content;
    }

    @Override
    public final HttpHeader getHttpHeader() {
        return this.httpHeader;
    }

    public boolean isLast() {
        return this.isLast;
    }

    public void setLast(boolean isLast) {
        this.isLast = isLast;
    }

    @Override
    public final boolean isHeader() {
        return false;
    }

    @Override
    public HttpContent append(HttpContent element) {
        if (this.isLast) {
            throw new IllegalStateException("Can not append to a last chunk");
        }
        if (HttpContent.isBroken(element)) {
            return element;
        }
        Buffer content2 = element.getContent();
        if (content2 != null && content2.hasRemaining()) {
            this.content = Buffers.appendBuffers(null, this.content, content2);
        }
        if (element.isLast()) {
            element.setContent(this.content);
            return element;
        }
        return this;
    }

    protected void reset() {
        this.isLast = false;
        this.content = Buffers.EMPTY_BUFFER;
        this.httpHeader = null;
    }

    @Override
    public void recycle() {
        this.reset();
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    public static class Builder<T extends Builder> {
        protected boolean last;
        protected Buffer content;
        protected HttpHeader httpHeader;

        protected Builder() {
        }

        public final T httpHeader(HttpHeader httpHeader) {
            this.httpHeader = httpHeader;
            return (T)this;
        }

        public final T last(boolean last) {
            this.last = last;
            return (T)this;
        }

        public final T content(Buffer content) {
            this.content = content;
            return (T)this;
        }

        public HttpContent build() {
            if (this.httpHeader == null) {
                throw new IllegalStateException("No HttpHeader specified to associate with this HttpContent.");
            }
            HttpContent httpContent = this.create();
            httpContent.httpHeader = this.httpHeader;
            httpContent.setLast(this.last);
            if (this.content != null) {
                httpContent.setContent(this.content);
            }
            return httpContent;
        }

        public void reset() {
            this.last = false;
            this.content = null;
            this.httpHeader = null;
        }

        protected HttpContent create() {
            return HttpContent.create();
        }
    }
}

