/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly.http;

import xyz.derkades.serverselectorx.lib.grizzly.Closeable;
import xyz.derkades.serverselectorx.lib.grizzly.OutputSink;
import xyz.derkades.serverselectorx.lib.grizzly.attributes.Attribute;
import xyz.derkades.serverselectorx.lib.grizzly.attributes.AttributeBuilder;
import xyz.derkades.serverselectorx.lib.grizzly.attributes.AttributeHolder;
import xyz.derkades.serverselectorx.lib.grizzly.attributes.AttributeStorage;
import xyz.derkades.serverselectorx.lib.grizzly.filterchain.FilterChainContext;
import xyz.derkades.serverselectorx.lib.grizzly.http.HttpRequestPacket;

public class HttpContext
implements AttributeStorage {
    private static final Attribute<HttpContext> HTTP_CONTEXT_ATTR = AttributeBuilder.DEFAULT_ATTRIBUTE_BUILDER.createAttribute(HttpContext.class.getName());
    private final AttributeStorage contextStorage;
    private final OutputSink outputSink;
    private final Closeable closeable;
    private final HttpRequestPacket request;

    protected HttpContext(AttributeStorage attributeStorage, OutputSink outputSink, Closeable closeable, HttpRequestPacket request) {
        this.contextStorage = attributeStorage;
        this.closeable = closeable;
        this.outputSink = outputSink;
        this.request = request;
    }

    public HttpRequestPacket getRequest() {
        return this.request;
    }

    public HttpContext attach(FilterChainContext ctx) {
        HTTP_CONTEXT_ATTR.set(ctx, this);
        return this;
    }

    @Override
    public final AttributeHolder getAttributes() {
        return this.contextStorage.getAttributes();
    }

    public AttributeStorage getContextStorage() {
        return this.contextStorage;
    }

    public OutputSink getOutputSink() {
        return this.outputSink;
    }

    public Closeable getCloseable() {
        return this.closeable;
    }

    public void close() {
        this.closeable.closeSilently();
    }

    public static HttpContext newInstance(AttributeStorage attributeStorage, OutputSink outputSink, Closeable closeable, HttpRequestPacket request) {
        return new HttpContext(attributeStorage, outputSink, closeable, request);
    }

    public static HttpContext get(FilterChainContext ctx) {
        return HTTP_CONTEXT_ATTR.get(ctx);
    }
}

