/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly.http;

import xyz.derkades.serverselectorx.lib.grizzly.ThreadCache;
import xyz.derkades.serverselectorx.lib.grizzly.http.HttpContent;
import xyz.derkades.serverselectorx.lib.grizzly.http.HttpHeader;
import xyz.derkades.serverselectorx.lib.grizzly.http.MimeHeadersPacket;
import xyz.derkades.serverselectorx.lib.grizzly.http.util.DataChunk;
import xyz.derkades.serverselectorx.lib.grizzly.http.util.Header;
import xyz.derkades.serverselectorx.lib.grizzly.http.util.HeaderValue;
import xyz.derkades.serverselectorx.lib.grizzly.http.util.MimeHeaders;

public class HttpTrailer
extends HttpContent
implements MimeHeadersPacket {
    private static final ThreadCache.CachedTypeIndex<HttpTrailer> CACHE_IDX = ThreadCache.obtainIndex(HttpTrailer.class, 16);
    private MimeHeaders trailers = new MimeHeaders();

    public static boolean isTrailer(HttpContent httpContent) {
        return httpContent != null && HttpTrailer.class.isAssignableFrom(httpContent.getClass());
    }

    public static HttpTrailer create() {
        return HttpTrailer.create(null);
    }

    public static HttpTrailer create(HttpHeader httpHeader) {
        HttpTrailer httpTrailer = ThreadCache.takeFromCache(CACHE_IDX);
        if (httpTrailer != null) {
            httpTrailer.httpHeader = httpHeader;
            return httpTrailer;
        }
        return new HttpTrailer(httpHeader);
    }

    public static Builder builder(HttpHeader httpHeader) {
        return (Builder)new Builder().httpHeader(httpHeader);
    }

    protected HttpTrailer(HttpHeader httpHeader) {
        super(httpHeader);
        this.trailers.mark();
    }

    @Override
    public final boolean isLast() {
        return true;
    }

    @Override
    public MimeHeaders getHeaders() {
        return this.trailers;
    }

    @Override
    public String getHeader(String name) {
        return this.trailers.getHeader(name);
    }

    @Override
    public String getHeader(Header header) {
        return this.trailers.getHeader(header);
    }

    @Override
    public void setHeader(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        this.trailers.setValue(name).setString(value);
    }

    @Override
    public void setHeader(String name, HeaderValue value) {
        if (name == null || value == null || !value.isSet()) {
            return;
        }
        value.serializeToDataChunk(this.trailers.setValue(name));
    }

    @Override
    public void setHeader(Header header, String value) {
        if (header == null || value == null) {
            return;
        }
        this.trailers.setValue(header).setString(value);
    }

    @Override
    public void setHeader(Header header, HeaderValue value) {
        if (header == null || value == null || !value.isSet()) {
            return;
        }
        value.serializeToDataChunk(this.trailers.setValue(header));
    }

    @Override
    public void addHeader(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        this.trailers.addValue(name).setString(value);
    }

    @Override
    public void addHeader(String name, HeaderValue value) {
        if (name == null || value == null || !value.isSet()) {
            return;
        }
        value.serializeToDataChunk(this.trailers.setValue(name));
    }

    @Override
    public void addHeader(Header header, String value) {
        if (header == null || value == null) {
            return;
        }
        DataChunk c = this.trailers.addValue(header);
        if (c != null) {
            c.setString(value);
        }
    }

    @Override
    public void addHeader(Header header, HeaderValue value) {
        if (header == null || value == null || !value.isSet()) {
            return;
        }
        value.serializeToDataChunk(this.trailers.setValue(header));
    }

    @Override
    public boolean containsHeader(String name) {
        return this.trailers.contains(name);
    }

    @Override
    public boolean containsHeader(Header header) {
        return this.trailers.contains(header);
    }

    protected void setTrailers(MimeHeaders trailers) {
        this.trailers = trailers;
        this.trailers.mark();
    }

    @Override
    protected void reset() {
        this.trailers.recycle();
        this.trailers.mark();
        super.reset();
    }

    @Override
    public void recycle() {
        this.reset();
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    public static final class Builder
    extends HttpContent.Builder<Builder> {
        private MimeHeaders mimeTrailers;

        protected Builder() {
        }

        public Builder headers(MimeHeaders mimeTrailers) {
            this.mimeTrailers = mimeTrailers;
            mimeTrailers.mark();
            return this;
        }

        public Builder header(String name, String value) {
            DataChunk c;
            if (this.mimeTrailers == null) {
                this.mimeTrailers = new MimeHeaders();
                this.mimeTrailers.mark();
            }
            if ((c = this.mimeTrailers.addValue(name)) != null) {
                c.setString(value);
            }
            return this;
        }

        @Override
        public HttpTrailer build() {
            HttpTrailer trailer = (HttpTrailer)super.build();
            if (this.mimeTrailers != null) {
                trailer.trailers = this.mimeTrailers;
            }
            return trailer;
        }

        @Override
        protected HttpContent create() {
            return HttpTrailer.create();
        }
    }
}

