/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly.http.server;

import java.util.Arrays;
import xyz.derkades.serverselectorx.lib.grizzly.http.CompressionConfig;
import xyz.derkades.serverselectorx.lib.grizzly.http.EncodingFilter;
import xyz.derkades.serverselectorx.lib.grizzly.http.HttpHeader;
import xyz.derkades.serverselectorx.lib.grizzly.http.HttpRequestPacket;
import xyz.derkades.serverselectorx.lib.grizzly.http.HttpResponsePacket;
import xyz.derkades.serverselectorx.lib.grizzly.http.server.CompressionLevel;
import xyz.derkades.serverselectorx.lib.grizzly.http.util.DataChunk;
import xyz.derkades.serverselectorx.lib.grizzly.http.util.Header;
import xyz.derkades.serverselectorx.lib.grizzly.http.util.MimeHeaders;

public class CompressionEncodingFilter
implements EncodingFilter {
    private final CompressionConfig compressionConfig;
    private final String[] aliases;

    public CompressionEncodingFilter(CompressionConfig compressionConfig, String[] aliases) {
        this.compressionConfig = new CompressionConfig(compressionConfig);
        this.aliases = Arrays.copyOf(aliases, aliases.length);
    }

    public CompressionEncodingFilter(CompressionConfig.CompressionModeI compressionMode, int compressionMinSize, String[] compressibleMimeTypes, String[] noCompressionUserAgents, String[] aliases) {
        this(compressionMode, compressionMinSize, compressibleMimeTypes, noCompressionUserAgents, aliases, false);
    }

    public CompressionEncodingFilter(CompressionConfig.CompressionModeI compressionMode, int compressionMinSize, String[] compressibleMimeTypes, String[] noCompressionUserAgents, String[] aliases, boolean enableDecompression) {
        CompressionConfig.CompressionMode mode;
        if (compressionMode instanceof CompressionConfig.CompressionMode) {
            mode = (CompressionConfig.CompressionMode)compressionMode;
        } else {
            assert (compressionMode instanceof CompressionLevel);
            mode = ((CompressionLevel)compressionMode).normalize();
        }
        this.compressionConfig = new CompressionConfig(mode, compressionMinSize, null, null, enableDecompression);
        this.compressionConfig.setCompressibleMimeTypes(compressibleMimeTypes);
        this.compressionConfig.setNoCompressionUserAgents(noCompressionUserAgents);
        this.aliases = Arrays.copyOf(aliases, aliases.length);
    }

    @Override
    public boolean applyEncoding(HttpHeader httpPacket) {
        if (httpPacket.isRequest()) {
            assert (httpPacket instanceof HttpRequestPacket);
            return false;
        }
        assert (httpPacket instanceof HttpResponsePacket);
        return CompressionEncodingFilter.canCompressHttpResponse((HttpResponsePacket)httpPacket, this.compressionConfig, this.aliases);
    }

    @Override
    public boolean applyDecoding(HttpHeader httpPacket) {
        if (!httpPacket.isRequest()) {
            return false;
        }
        assert (httpPacket instanceof HttpRequestPacket);
        return CompressionEncodingFilter.canDecompressHttpRequest((HttpRequestPacket)httpPacket, this.compressionConfig, this.aliases);
    }

    protected static boolean canCompressHttpResponse(HttpResponsePacket response, CompressionConfig compressionConfig, String[] aliases) {
        if (!response.getContentEncodings().isEmpty()) {
            return false;
        }
        MimeHeaders responseHeaders = response.getHeaders();
        DataChunk contentEncodingMB = responseHeaders.getValue(Header.ContentEncoding);
        if (contentEncodingMB != null && !contentEncodingMB.isNull()) {
            return false;
        }
        if (!CompressionConfig.isClientSupportCompression(compressionConfig, response.getRequest(), aliases)) {
            return false;
        }
        if (compressionConfig.getCompressionMode() == CompressionConfig.CompressionMode.FORCE) {
            response.setChunked(true);
            response.setContentLength(-1);
            return true;
        }
        long contentLength = response.getContentLength();
        if ((contentLength == -1L || contentLength >= (long)compressionConfig.getCompressionMinSize()) && compressionConfig.checkMimeType(response.getContentType())) {
            response.setChunked(true);
            response.setContentLength(-1);
            return true;
        }
        return false;
    }

    protected static boolean canDecompressHttpRequest(HttpRequestPacket request, CompressionConfig config, String[] aliases) {
        if (!config.isDecompressionEnabled()) {
            return false;
        }
        String contentEncoding = request.getHeader(Header.ContentEncoding);
        if (contentEncoding == null) {
            return false;
        }
        contentEncoding = contentEncoding.trim();
        for (String alias : aliases) {
            if (!alias.equals(contentEncoding)) continue;
            return true;
        }
        return false;
    }
}

