/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly.http.server;

import xyz.derkades.serverselectorx.lib.grizzly.ThreadCache;

public final class SuspendStatus {
    private static final ThreadCache.CachedTypeIndex<SuspendStatus> CACHE_IDX = ThreadCache.obtainIndex(SuspendStatus.class, 4);
    private State state;
    private final Thread initThread = Thread.currentThread();

    public static SuspendStatus create() {
        SuspendStatus status = ThreadCache.takeFromCache(CACHE_IDX);
        if (status == null) {
            status = new SuspendStatus();
        }
        assert (status.initThread == Thread.currentThread());
        status.state = State.NOT_SUSPENDED;
        return status;
    }

    private SuspendStatus() {
    }

    public void suspend() {
        assert (Thread.currentThread() == this.initThread);
        if (this.state != State.NOT_SUSPENDED) {
            throw new IllegalStateException("Can not suspend. Expected suspend state='" + (Object)((Object)State.NOT_SUSPENDED) + "' but was '" + (Object)((Object)this.state) + "'");
        }
        this.state = State.SUSPENDED;
    }

    boolean getAndInvalidate() {
        assert (Thread.currentThread() == this.initThread);
        boolean wasSuspended = this.state == State.SUSPENDED;
        this.state = State.INVALIDATED;
        ThreadCache.putToCache(this.initThread, CACHE_IDX, this);
        return wasSuspended;
    }

    public void reset() {
        assert (Thread.currentThread() == this.initThread);
        this.state = State.NOT_SUSPENDED;
    }

    private static enum State {
        NOT_SUSPENDED,
        SUSPENDED,
        INVALIDATED;

    }
}

