/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly.http.server.http2;

import xyz.derkades.serverselectorx.lib.grizzly.ThreadCache;
import xyz.derkades.serverselectorx.lib.grizzly.filterchain.FilterChainEvent;
import xyz.derkades.serverselectorx.lib.grizzly.http.HttpHeader;
import xyz.derkades.serverselectorx.lib.grizzly.http.HttpRequestPacket;
import xyz.derkades.serverselectorx.lib.grizzly.http.Method;
import xyz.derkades.serverselectorx.lib.grizzly.http.server.http2.PushBuilder;
import xyz.derkades.serverselectorx.lib.grizzly.http.util.MimeHeaders;

public class PushEvent
implements FilterChainEvent {
    private static final ThreadCache.CachedTypeIndex<PushEvent> CACHE_IDX = ThreadCache.obtainIndex(PushEvent.class, 8);
    public static final Object TYPE = PushEvent.class.getName();
    private String method;
    private MimeHeaders headers = new MimeHeaders();
    private String path;
    private HttpRequestPacket httpRequest;

    private PushEvent() {
    }

    @Override
    public Object type() {
        return TYPE;
    }

    public static PushEvent create(PushBuilder builder) {
        PushEvent pushEvent = ThreadCache.takeFromCache(CACHE_IDX);
        if (pushEvent == null) {
            pushEvent = new PushEvent();
        }
        return pushEvent.init(builder);
    }

    public String getMethod() {
        return this.method;
    }

    public MimeHeaders getHeaders() {
        return this.headers;
    }

    public String getPath() {
        return this.path;
    }

    public HttpHeader getHttpRequest() {
        return this.httpRequest;
    }

    public void recycle() {
        this.method = null;
        this.headers.recycle();
        this.path = null;
        this.httpRequest = null;
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    public static PushEventBuilder builder() {
        return new PushEventBuilder();
    }

    private static PushEvent create(PushEventBuilder builder) {
        PushEvent pushEvent = ThreadCache.takeFromCache(CACHE_IDX);
        if (pushEvent == null) {
            pushEvent = new PushEvent();
        }
        return pushEvent.init(builder);
    }

    private PushEvent init(PushBuilder builder) {
        this.method = builder.method;
        this.headers.copyFrom(builder.headers);
        this.path = builder.path;
        this.httpRequest = builder.request.getRequest();
        return this;
    }

    private PushEvent init(PushEventBuilder builder) {
        this.method = builder.method;
        this.headers.copyFrom(builder.headers);
        this.path = builder.path;
        this.httpRequest = builder.httpRequest;
        return this;
    }

    public static final class PushEventBuilder {
        private String method = Method.GET.getMethodString();
        private MimeHeaders headers = new MimeHeaders();
        private String path;
        private HttpRequestPacket httpRequest;

        private PushEventBuilder() {
        }

        public PushEventBuilder method(String val) {
            if (this.method == null) {
                throw new NullPointerException();
            }
            if (Method.POST.getMethodString().equals(this.method) || Method.PUT.getMethodString().equals(this.method) || Method.DELETE.getMethodString().equals(this.method) || Method.CONNECT.getMethodString().equals(this.method) || Method.OPTIONS.getMethodString().equals(this.method) || Method.TRACE.getMethodString().equals(this.method)) {
                throw new IllegalArgumentException();
            }
            this.method = val;
            return this;
        }

        public PushEventBuilder headers(MimeHeaders val) {
            if (val == null) {
                throw new NullPointerException();
            }
            this.headers.copyFrom(val);
            return this;
        }

        public PushEventBuilder path(String val) {
            this.path = PushEventBuilder.validate(val);
            return this;
        }

        public PushEventBuilder httpRequest(HttpRequestPacket val) {
            if (val == null) {
                throw new NullPointerException();
            }
            this.httpRequest = val;
            return this;
        }

        public PushEvent build() {
            if (this.path == null || this.httpRequest == null || this.headers == null) {
                throw new IllegalArgumentException();
            }
            return PushEvent.create(this);
        }

        private static String validate(String val) {
            return val != null && !val.isEmpty() ? val : null;
        }
    }
}

