/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.lib.grizzly.nio.transport;

import java.io.IOException;
import xyz.derkades.serverselectorx.lib.grizzly.Buffer;
import xyz.derkades.serverselectorx.lib.grizzly.CompletionHandler;
import xyz.derkades.serverselectorx.lib.grizzly.Connection;
import xyz.derkades.serverselectorx.lib.grizzly.Interceptor;
import xyz.derkades.serverselectorx.lib.grizzly.ReadResult;
import xyz.derkades.serverselectorx.lib.grizzly.Reader;
import xyz.derkades.serverselectorx.lib.grizzly.Transport;
import xyz.derkades.serverselectorx.lib.grizzly.streams.AbstractStreamReader;
import xyz.derkades.serverselectorx.lib.grizzly.streams.BufferedInput;

public final class DefaultStreamReader
extends AbstractStreamReader {
    public DefaultStreamReader(Connection connection) {
        super(connection, new Input());
        ((Input)this.input).parentStreamReader = this;
    }

    public Input getSource() {
        return (Input)this.input;
    }

    public static final class Input
    extends BufferedInput {
        private DefaultStreamReader parentStreamReader;
        private InputInterceptor interceptor;

        @Override
        protected void onOpenInputSource() throws IOException {
            Connection connection = this.parentStreamReader.getConnection();
            Transport transport = connection.getTransport();
            Reader reader = transport.getReader(connection);
            this.interceptor = new InputInterceptor();
            reader.read(connection, null, null, this.interceptor);
        }

        @Override
        protected void onCloseInputSource() throws IOException {
            this.interceptor.isDone = true;
            this.interceptor = null;
        }

        @Override
        protected void notifyCompleted(CompletionHandler<Integer> completionHandler) {
            if (completionHandler != null) {
                completionHandler.completed(this.compositeBuffer.remaining());
            }
        }

        @Override
        protected void notifyFailure(CompletionHandler<Integer> completionHandler, Throwable failure) {
            if (completionHandler != null) {
                completionHandler.failed(failure);
            }
        }

        private class InputInterceptor
        implements Interceptor<ReadResult<Buffer, ?>> {
            boolean isDone = false;

            private InputInterceptor() {
            }

            @Override
            public int intercept(int event, Object context, ReadResult<Buffer, ?> result) {
                if (event == 1) {
                    Buffer buffer = result.getMessage();
                    result.setMessage(null);
                    if (buffer == null) {
                        return 2;
                    }
                    buffer.trim();
                    Input.this.append(buffer);
                    if (this.isDone) {
                        return 1;
                    }
                    return 6;
                }
                return 0;
            }
        }
    }
}

